/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.blocks;

import com.scouter.netherdepthsupgrade.blocks.GrowingLavaPlantBlock;
import com.scouter.netherdepthsupgrade.blocks.GrowingLavaPlantHeadBlock;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class GrowingLavaPlantBodyBlock
extends GrowingLavaPlantBlock
implements BonemealableBlock {
    protected GrowingLavaPlantBodyBlock(BlockBehaviour.Properties p_53886_, Direction p_53887_, VoxelShape p_53888_, boolean p_53889_) {
        super(p_53886_, p_53887_, p_53888_, p_53889_);
    }

    protected BlockState updateHeadAfterConvertedFromBody(BlockState p_153326_, BlockState p_153327_) {
        return p_153327_;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == this.growthDirection.getOpposite() && !pState.canSurvive((LevelReader)pLevel, pCurrentPos)) {
            pLevel.scheduleTick(pCurrentPos, (Block)this, 1);
        }
        GrowingLavaPlantHeadBlock growingplantheadblock = this.getHeadBlock();
        if (pFacing == this.growthDirection && !pFacingState.is((Block)this) && !pFacingState.is((Block)growingplantheadblock)) {
            return this.updateHeadAfterConvertedFromBody(pState, growingplantheadblock.getStateForPlacement(pLevel));
        }
        if (this.scheduleFluidTicks) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.LAVA, Fluids.LAVA.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public ItemStack getCloneItemStack(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)this.getHeadBlock());
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        Optional<BlockPos> optional = this.getHeadPos((BlockGetter)pLevel, pPos, pState.getBlock());
        return optional.isPresent() && this.getHeadBlock().canGrowInto(pLevel.getBlockState(optional.get().relative(this.growthDirection)));
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        Optional<BlockPos> optional = this.getHeadPos((BlockGetter)pLevel, pPos, pState.getBlock());
        if (optional.isPresent()) {
            BlockState blockstate = pLevel.getBlockState(optional.get());
            ((GrowingLavaPlantHeadBlock)blockstate.getBlock()).performBonemeal(pLevel, pRandom, optional.get(), blockstate);
        }
    }

    private Optional<BlockPos> getHeadPos(BlockGetter p_153323_, BlockPos p_153324_, Block p_153325_) {
        return BlockUtil.getTopConnectedBlock((BlockGetter)p_153323_, (BlockPos)p_153324_, (Block)p_153325_, (Direction)this.growthDirection, (Block)this.getHeadBlock());
    }

    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        boolean flag = super.canBeReplaced(pState, pUseContext);
        return flag && pUseContext.getItemInHand().is(this.getHeadBlock().asItem()) ? false : flag;
    }

    @Override
    protected Block getBodyBlock() {
        return this;
    }
}

