/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.routers.mixin;

import com.benbenlaw.routers.block.entity.ExporterBlockEntity;
import com.benbenlaw.routers.block.entity.ImporterBlockEntity;
import java.lang.reflect.Field;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.PressureChamberValveBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={PressureChamberValveBlockEntity.class})
public abstract class MixinPressureChamberValve {
    @Inject(method={"checkForAirLeak"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventLeakIfRouterNearby(CallbackInfo ci) throws Exception {
        PressureChamberValveBlockEntity self = (PressureChamberValveBlockEntity)this;
        if (self.getLevel() == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            BlockPos neighborPos = self.getBlockPos().relative(dir);
            BlockEntity neighbor = self.getLevel().getBlockEntity(neighborPos);
            if (!(neighbor instanceof ImporterBlockEntity) && !(neighbor instanceof ExporterBlockEntity)) continue;
            Field airHandlerField = AbstractAirHandlingBlockEntity.class.getDeclaredField("airHandler");
            airHandlerField.setAccessible(true);
            IAirHandlerMachine handler = (IAirHandlerMachine)airHandlerField.get(self);
            handler.setSideLeaking(null);
            ci.cancel();
            return;
        }
    }
}

