/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.recipes;

import com.benbenlaw.core.recipe.ChanceResult;
import com.benbenlaw.core.recipe.NoInventoryRecipe;
import com.benbenlaw.inworldrecipes.recipes.BlockTarget;
import com.benbenlaw.inworldrecipes.recipes.BlockTargetCodec;
import com.benbenlaw.inworldrecipes.util.ClickType;
import com.benbenlaw.inworldrecipes.util.ClickTypeCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record BlockInteractionRecipe(ClickType clickType, BlockTarget targetBlock, SizedIngredient heldItem, BlockState outputBlockState, NonNullList<ChanceResult> chanceResults, boolean damageHeldItem, boolean consumeHeldItem, boolean popItems, boolean ignoreBlockState) implements Recipe<NoInventoryRecipe>
{
    public boolean matches(NoInventoryRecipe p_346065_, Level p_345375_) {
        return true;
    }

    public ItemStack assemble(NoInventoryRecipe p_345149_, HolderLookup.Provider p_346030_) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public NonNullList<ChanceResult> getRollResults() {
        return this.chanceResults;
    }

    public List<ItemStack> rollResults(RandomSource rand) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        NonNullList<ChanceResult> rollResults = this.getRollResults();
        for (ChanceResult output : rollResults) {
            ItemStack stack = output.rollOutput(rand);
            if (stack.isEmpty()) continue;
            results.add(stack);
        }
        return results;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<BlockInteractionRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<BlockInteractionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ClickTypeCodec.CLICK_TYPE_CODEC.fieldOf("click_type").forGetter(BlockInteractionRecipe::clickType), (App)BlockTargetCodec.CODEC.fieldOf("target_block_state").forGetter(BlockInteractionRecipe::targetBlock), (App)SizedIngredient.FLAT_CODEC.fieldOf("held_item").forGetter(BlockInteractionRecipe::heldItem), (App)BlockState.CODEC.optionalFieldOf("output_block_state").forGetter(r -> Optional.ofNullable(r.outputBlockState)), (App)Codec.list((Codec)ChanceResult.CODEC).optionalFieldOf("results", List.of()).flatXmap(list -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)list);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(BlockInteractionRecipe::getRollResults), (App)Codec.BOOL.fieldOf("damage_held_item").forGetter(BlockInteractionRecipe::damageHeldItem), (App)Codec.BOOL.fieldOf("consume_held_item").forGetter(BlockInteractionRecipe::consumeHeldItem), (App)Codec.BOOL.fieldOf("pop_items").forGetter(BlockInteractionRecipe::popItems), (App)Codec.BOOL.optionalFieldOf("ignore_block_state", (Object)false).forGetter(BlockInteractionRecipe::ignoreBlockState)).apply((Applicative)instance, (clickType, blockState, heldItem, outputOpt, results, damageHeldItem, consumeHeldItem, popItems, ignoreBlockState) -> new BlockInteractionRecipe((ClickType)((Object)((Object)clickType)), (BlockTarget)blockState, (SizedIngredient)heldItem, outputOpt.orElse(null), (NonNullList<ChanceResult>)results, (boolean)damageHeldItem, (boolean)consumeHeldItem, (boolean)popItems, (boolean)ignoreBlockState)));
        private final StreamCodec<RegistryFriendlyByteBuf, BlockInteractionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<BlockInteractionRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, BlockInteractionRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static BlockInteractionRecipe read(RegistryFriendlyByteBuf buffer) {
            Record blockTarget;
            ClickType clickType = ClickTypeCodec.readFromBuffer(buffer);
            boolean isTag = buffer.readBoolean();
            if (isTag) {
                ResourceLocation tagId = buffer.readResourceLocation();
                blockTarget = new BlockTarget.Tag((TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tagId));
            } else {
                BlockState state = Block.stateById((int)buffer.readInt());
                blockTarget = new BlockTarget.Single(state);
            }
            SizedIngredient heldItem = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            BlockState outputBlockState = null;
            if (buffer.readBoolean()) {
                outputBlockState = Block.stateById((int)buffer.readInt());
            }
            int size = buffer.readVarInt();
            NonNullList outputs = NonNullList.withSize((int)size, (Object)ChanceResult.EMPTY);
            outputs.replaceAll(ignored -> ChanceResult.read((RegistryFriendlyByteBuf)buffer));
            boolean damageHeldItem = buffer.readBoolean();
            boolean consumeHeldItem = buffer.readBoolean();
            boolean popItem = buffer.readBoolean();
            boolean ignoreBlockState = buffer.readBoolean();
            return new BlockInteractionRecipe(clickType, (BlockTarget)((Object)blockTarget), heldItem, outputBlockState, (NonNullList<ChanceResult>)outputs, damageHeldItem, consumeHeldItem, popItem, ignoreBlockState);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static void write(RegistryFriendlyByteBuf buffer, BlockInteractionRecipe recipe) {
            Object tag;
            ClickTypeCodec.writeToBuffer(buffer, recipe.clickType);
            BlockTarget blockTarget = recipe.targetBlock;
            if (blockTarget instanceof BlockTarget.Tag) {
                BlockState tag2;
                tag = (BlockTarget.Tag)blockTarget;
                try {
                    tag2 = var7_5 = ((BlockTarget.Tag)tag).tag();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                buffer.writeBoolean(true);
                buffer.writeResourceLocation(tag2.location());
            } else {
                blockTarget = recipe.targetBlock;
                if (blockTarget instanceof BlockTarget.Single) {
                    BlockState target;
                    BlockTarget.Single single = (BlockTarget.Single)blockTarget;
                    {
                        target = var7_5 = single.blockState();
                    }
                    buffer.writeBoolean(false);
                    buffer.writeInt(Block.getId((BlockState)target));
                }
            }
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.heldItem);
            buffer.writeBoolean(recipe.outputBlockState != null);
            if (recipe.outputBlockState != null) {
                buffer.writeInt(Block.getId((BlockState)recipe.outputBlockState));
            }
            buffer.writeVarInt(recipe.chanceResults.size());
            tag = recipe.chanceResults.iterator();
            while (true) {
                if (!tag.hasNext()) {
                    buffer.writeBoolean(recipe.damageHeldItem);
                    buffer.writeBoolean(recipe.consumeHeldItem);
                    buffer.writeBoolean(recipe.popItems);
                    buffer.writeBoolean(recipe.ignoreBlockState);
                    return;
                }
                ChanceResult output = (ChanceResult)tag.next();
                output.write(buffer);
            }
        }
    }

    public static class Type
    implements RecipeType<BlockInteractionRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

