/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.recipes;

import com.benbenlaw.core.recipe.NoInventoryRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public record BlockConversionRecipe(String blockToConvert, String convertedBlock, boolean popBlock, boolean requiresSunlight, boolean requiresMoonlight, String dimension, int duration) implements Recipe<NoInventoryRecipe>
{
    public boolean matches(NoInventoryRecipe p_346065_, Level p_345375_) {
        return true;
    }

    public ItemStack assemble(NoInventoryRecipe p_345149_, HolderLookup.Provider p_346030_) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return ItemStack.EMPTY;
    }

    public Block getBlockToConvert() {
        if (!this.blockToConvert.contains("#")) {
            return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)this.blockToConvert));
        }
        return null;
    }

    public TagKey<Block> getBlockToConvertTag() {
        if (this.blockToConvert.contains("#")) {
            return TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.parse((String)this.blockToConvert.replace("#", "")));
        }
        return null;
    }

    public Block getConvertedBlock() {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)this.convertedBlock));
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<BlockConversionRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<BlockConversionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("block_to_convert").forGetter(BlockConversionRecipe::blockToConvert), (App)Codec.STRING.fieldOf("converted_block").forGetter(BlockConversionRecipe::convertedBlock), (App)Codec.BOOL.optionalFieldOf("pop_block", (Object)false).forGetter(BlockConversionRecipe::popBlock), (App)Codec.BOOL.optionalFieldOf("requires_sunlight", (Object)false).forGetter(BlockConversionRecipe::requiresSunlight), (App)Codec.BOOL.optionalFieldOf("requires_moonlight", (Object)false).forGetter(BlockConversionRecipe::requiresMoonlight), (App)Codec.STRING.optionalFieldOf("dimension", (Object)"none").forGetter(BlockConversionRecipe::dimension), (App)Codec.INT.optionalFieldOf("duration", (Object)200).forGetter(BlockConversionRecipe::duration)).apply((Applicative)instance, BlockConversionRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, BlockConversionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<BlockConversionRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, BlockConversionRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static BlockConversionRecipe read(RegistryFriendlyByteBuf buffer) {
            String blockToConvert = buffer.readUtf();
            String convertedBlock = buffer.readUtf();
            boolean popBlock = buffer.readBoolean();
            boolean requiresSunlight = buffer.readBoolean();
            boolean requiresMoonlight = buffer.readBoolean();
            String dimension = buffer.readUtf();
            int duration = buffer.readInt();
            return new BlockConversionRecipe(blockToConvert, convertedBlock, popBlock, requiresSunlight, requiresMoonlight, dimension, duration);
        }

        private static void write(RegistryFriendlyByteBuf buffer, BlockConversionRecipe recipe) {
            buffer.writeUtf(recipe.blockToConvert);
            buffer.writeUtf(recipe.convertedBlock);
            buffer.writeBoolean(recipe.popBlock);
            buffer.writeBoolean(recipe.requiresSunlight);
            buffer.writeBoolean(recipe.requiresMoonlight);
            buffer.writeUtf(recipe.dimension);
            buffer.writeInt(recipe.duration);
        }
    }

    public static class Type
    implements RecipeType<BlockConversionRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

