/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.inworldrecipes.integration.jei;

import com.benbenlaw.inworldrecipes.integration.jei.JEIInWorldRecipesPlugin;
import com.benbenlaw.inworldrecipes.recipes.RightClickOnBlockTransformsBlockRecipe;
import com.benbenlaw.inworldrecipes.recipes.RightClickOnBlockTransformsItemRecipe;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RightClickOnBlockTransformsItemRecipeCategory
implements IRecipeCategory<RightClickOnBlockTransformsItemRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"inworldrecipes", (String)"right_click_on_block_transforms_item");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"inworldrecipes", (String)"textures/gui/jei_right_click_on_block_item.png");
    static final RecipeType<RightClickOnBlockTransformsItemRecipe> RECIPE_TYPE = RecipeType.create((String)"inworldrecipes", (String)"right_click_on_block_transforms_item", RightClickOnBlockTransformsItemRecipe.class);
    int yOffset = 21;
    int totalMessages;
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;

    @Nullable
    public ResourceLocation getRegistryName(RightClickOnBlockTransformsItemRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RightClickOnBlockTransformsBlockRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((RightClickOnBlockTransformsBlockRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public RightClickOnBlockTransformsItemRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 139, 18);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.DIAMOND_BLOCK));
    }

    @NotNull
    public RecipeType<RightClickOnBlockTransformsItemRecipe> getRecipeType() {
        return JEIInWorldRecipesPlugin.RIGHT_CLICK_ON_BLOCK_TRANSFORM_ITEM_RECIPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"Right Click On Block Item");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RightClickOnBlockTransformsItemRecipe recipe, @NotNull IFocusGroup focusGroup) {
        this.totalMessages = 0;
        builder.addSlot(RecipeIngredientRole.CATALYST, 4, 2).addItemStacks(Arrays.asList(recipe.heldItem().getItems()));
        builder.addSlot(RecipeIngredientRole.INPUT, 40, 2).addIngredients(recipe.targetBlock());
        List<ItemStack> results = recipe.getResults();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 2).addItemStacks(results);
        if (recipe.damageHeldItem()) {
            ++this.totalMessages;
        }
        if (recipe.consumeHeldItem()) {
            ++this.totalMessages;
        }
        if (recipe.popItem()) {
            ++this.totalMessages;
        }
        if (recipe.destroyTargetBlock()) {
            ++this.totalMessages;
        }
        this.background = this.helper.createDrawable(TEXTURE, 0, 0, 139, 18 + this.totalMessages * 10);
    }

    public void draw(RightClickOnBlockTransformsItemRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.yOffset = 20;
        if (recipe.damageHeldItem()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Damages Item", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
        if (recipe.consumeHeldItem()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Consumes Item", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
        if (recipe.popItem()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Item Drops In World", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
        if (recipe.destroyTargetBlock()) {
            guiGraphics.drawString(Minecraft.getInstance().font, "Destroys Target Block", 0, this.yOffset, Color.GRAY.getRGB(), false);
            this.yOffset += 10;
        }
    }
}

