/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.mobspawners;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.mobspawners.MobSpawnerObj;
import com.telepathicgrunt.repurposedstructures.mixins.features.DungeonFeatureAccessor;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import org.apache.logging.log4j.Level;

public class MobSpawnerManager
extends SimpleJsonResourceReloadListener {
    public static final MobSpawnerManager MOB_SPAWNER_MANAGER = new MobSpawnerManager();
    private Map<ResourceLocation, List<MobSpawnerObj>> spawnerMap = ImmutableMap.of();

    public MobSpawnerManager() {
        super(RepurposedStructures.GSON, "rs_spawners");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                List spawnerMobEntries = (List)RepurposedStructures.GSON.fromJson(jsonElement.getAsJsonObject().get("mobs"), new TypeToken<List<MobSpawnerObj>>(this){}.getType());
                for (int i = spawnerMobEntries.size() - 1; i >= 0; --i) {
                    MobSpawnerObj entry = (MobSpawnerObj)spawnerMobEntries.get(i);
                    entry.setEntityType();
                    if (entry.weight == 0.0f || entry.entityType == null) {
                        spawnerMobEntries.remove(i);
                        continue;
                    }
                    if (!(entry.weight < 0.0f)) continue;
                    throw new Exception("Error: Found " + entry.name + " entry has a weight less than 0. Please remove the entry if you don't want a mob to be picked");
                }
                builder.put(fileIdentifier, (Object)spawnerMobEntries);
            }
            catch (Exception e) {
                RepurposedStructures.LOGGER.error("Repurposed Structures Error: Couldn't parse spawner mob list {}", fileIdentifier, (Object)e);
            }
        });
        this.spawnerMap = builder.build();
    }

    public EntityType<?> getSpawnerMob(ResourceLocation spawnerJsonEntry, RandomSource random) {
        List<MobSpawnerObj> spawnerMobEntries = this.spawnerMap.get(spawnerJsonEntry);
        if (spawnerMobEntries == null) {
            RepurposedStructures.LOGGER.log(Level.ERROR, "\n***************************************\nFailed to get mob. Please check that " + String.valueOf(spawnerJsonEntry) + ".json is correct or that no other mod is interfering with how vanilla reads data folders. Let TelepathicGrunt know about this too!\n***************************************");
            return (EntityType)Util.getRandom((Object[])DungeonFeatureAccessor.getMOBS(), (RandomSource)random);
        }
        float totalWeight = 0.0f;
        for (MobSpawnerObj mobSpawnerObj : spawnerMobEntries) {
            totalWeight += mobSpawnerObj.weight;
        }
        if (totalWeight == 0.0f) {
            return null;
        }
        float randomWeight = random.nextFloat() * totalWeight;
        int index = 0;
        try {
            while (true) {
                if ((randomWeight -= spawnerMobEntries.get((int)index).weight) <= 0.0f) {
                    return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)spawnerMobEntries.get((int)index).name));
                }
                ++index;
            }
        }
        catch (Exception e) {
            RepurposedStructures.LOGGER.log(Level.ERROR, "\n***************************************\nFailed to get mob. Please check that " + String.valueOf(spawnerJsonEntry) + ".json is correct and let Telepathicgrunt (mod author) know he broke the mob spawner code!\n***************************************");
            return EntityType.PIG;
        }
    }
}

