/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import net.minecraft.util.Mth;

public abstract class DragPanelScreenAddon
extends BasicScreenAddon {
    private final int minX;
    private final int minY;
    private final int maxX;
    private final int maxY;
    private final int panelSizeX;
    private final int panelSizeY;
    private int scrollX;
    private int scrollY;

    protected DragPanelScreenAddon(int posX, int posY, int sizeX, int sizeY, int panelSizeX, int panelSizeY) {
        super(posX, posY);
        this.panelSizeX = panelSizeX;
        this.panelSizeY = panelSizeY;
        this.minX = 0;
        this.maxX = sizeX;
        this.minY = 0;
        this.maxY = sizeY;
        this.scrollY = 0;
        this.scrollX = 0;
    }

    @Override
    public int getXSize() {
        return this.panelSizeX;
    }

    @Override
    public int getYSize() {
        return this.panelSizeY;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        this.scrollX = (int)Math.round(Mth.clamp((double)((double)this.scrollX - mouseX), (double)this.minX, (double)this.maxX));
        this.scrollY = (int)Math.round(Mth.clamp((double)((double)this.scrollY - mouseY), (double)this.minY, (double)this.maxY));
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }
}

