/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.world.block.entity.item.panels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.mangorage.swiss.registry.SWISSBlockEntities;
import org.mangorage.swiss.storage.device.DeviceType;
import org.mangorage.swiss.storage.device.ItemDevice;
import org.mangorage.swiss.world.block.entity.TickingBlockEntity;
import org.mangorage.swiss.world.block.entity.base.BaseStorageBlockEntity;

public final class TestBlockEntity
extends BaseStorageBlockEntity
implements TickingBlockEntity,
ItemDevice {
    private int ticks = 0;
    public final ContainerData data;
    private final ItemStackHandler itemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            TestBlockEntity.this.setChanged();
        }
    };

    public TestBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)SWISSBlockEntities.TEST_BLOCK_ENTITY.get(), pos, blockState);
        this.data = new ContainerData(this){

            public int get(int index) {
                return 0;
            }

            public void set(int index, int value) {
            }

            public int getCount() {
                return 1;
            }
        };
    }

    @Override
    public void tickServer() {
        ++this.ticks;
        if (this.ticks % 20 == 0) {
            this.connectToNetwork();
        }
    }

    @Override
    public IItemHandler getItemHandler() {
        BlockPos above = this.getBlockPos().above();
        BlockState aboveState = this.level.getBlockState(above);
        BlockEntity aboveEntity = this.level.getBlockEntity(above);
        return (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.level, above, aboveState, aboveEntity, (Object)Direction.DOWN);
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    @Override
    public boolean canInsert(DeviceType type) {
        return false;
    }

    @Override
    public boolean canExtract(DeviceType type) {
        return false;
    }

    public List<ItemStack> getItems() {
        List<ItemStack> items = this.getNetwork().getItemDevices().filter(device -> device.isValidDevice() && device.canExtract(DeviceType.ITEM)).map(ItemDevice::getItemHandler).filter(Objects::nonNull).map(handler -> {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                stacks.add(handler.getStackInSlot(slot).copy());
            }
            return stacks;
        }).flatMap(Collection::stream).filter(item -> !item.isEmpty()).toList();
        return items;
    }
}

