/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.world.block.entity.item.interfaces;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.mangorage.swiss.StorageNetworkManager;
import org.mangorage.swiss.registry.SWISSBlockEntities;
import org.mangorage.swiss.screen.interfaces.config_block.ConfigureBlockNetworkMenu;
import org.mangorage.swiss.screen.util.HasMenu;
import org.mangorage.swiss.storage.device.DeviceType;
import org.mangorage.swiss.storage.device.ItemDevice;
import org.mangorage.swiss.storage.network.NetworkInfo;
import org.mangorage.swiss.world.block.InterfaceNetworkBlock;
import org.mangorage.swiss.world.block.entity.TickingBlockEntity;
import org.mangorage.swiss.world.block.entity.base.BaseStorageBlockEntity;

public final class ItemInterfaceBlockEntity
extends BaseStorageBlockEntity
implements TickingBlockEntity,
ItemDevice,
HasMenu {
    private int ticks = 0;

    public ItemInterfaceBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)SWISSBlockEntities.STORAGE_ITEM_INTERFACE_BLOCK_ENTITY.get(), pos, blockState);
    }

    @Override
    public void tickServer() {
        ++this.ticks;
        if (this.ticks % 20 == 0) {
            this.connectToNetwork();
        }
    }

    @Override
    public IItemHandler getItemHandler() {
        ServerPlayer ownerPlayer;
        UUID owner;
        Direction facing = (Direction)this.getBlockState().getValue((Property)InterfaceNetworkBlock.FACING);
        BlockPos outputPos = this.getBlockPos().relative(facing.getOpposite());
        BlockState outputState = this.level.getBlockState(outputPos);
        BlockEntity outputBE = this.level.getBlockEntity(outputPos);
        if (outputState.isAir()) {
            return null;
        }
        if (outputState.is(Blocks.ENDER_CHEST) && (owner = this.getOwner()) != null && (ownerPlayer = this.level.getServer().getPlayerList().getPlayer(owner)) != null) {
            return new InvWrapper((Container)ownerPlayer.getEnderChestInventory());
        }
        return (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.level, outputPos, outputState, outputBE, (Object)facing);
    }

    @Override
    public boolean canInsert(DeviceType type) {
        return true;
    }

    @Override
    public boolean canExtract(DeviceType type) {
        return true;
    }

    @Override
    public void openMenu(Player player) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new ConfigureBlockNetworkMenu(windowId, playerInventory, this.getBlockPos()), (Component)Component.translatable((String)"block.swiss.storage_item_interface")), buf -> {
            buf.writeBlockPos(this.getBlockPos());
            List<NetworkInfo> info = StorageNetworkManager.getInstance().getNetworkInfo((ServerPlayer)player);
            NetworkInfo.LIST_STREAM_CODEC.encode(buf, info);
        });
    }
}

