/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.world.block.entity.item.interfaces;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.mangorage.swiss.StorageNetworkManager;
import org.mangorage.swiss.registry.SWISSBlockEntities;
import org.mangorage.swiss.screen.interfaces.importer.ImporterMenu;
import org.mangorage.swiss.screen.util.HasMenu;
import org.mangorage.swiss.storage.network.NetworkInfo;
import org.mangorage.swiss.storage.util.IRightClickable;
import org.mangorage.swiss.storage.util.ItemHandlerLookup;
import org.mangorage.swiss.world.block.InterfaceNetworkBlock;
import org.mangorage.swiss.world.block.entity.TickingBlockEntity;
import org.mangorage.swiss.world.block.entity.base.BaseStorageBlockEntity;

public final class ItemImporterBlockEntity
extends BaseStorageBlockEntity
implements TickingBlockEntity,
IRightClickable,
HasMenu {
    private int ticks = 0;
    public final List<ItemStack> importItems = new ArrayList<ItemStack>();

    public ItemImporterBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)SWISSBlockEntities.IMPORTER_ITEM_INTERFACE_BLOCK_ENTITY.get(), pos, blockState);
    }

    @Override
    public void tickServer() {
        block4: {
            ItemHandlerLookup networkLookup;
            IItemHandler input;
            block5: {
                ++this.ticks;
                if (this.ticks % 20 != 0) break block4;
                this.connectToNetwork();
                input = this.getInput();
                if (input == null) {
                    return;
                }
                networkLookup = ItemHandlerLookup.getLookupForInsert(this.getNetwork());
                if (!this.importItems.isEmpty()) break block5;
                for (int slot = 0; slot < input.getSlots(); ++slot) {
                    if (input.getStackInSlot(slot).isEmpty()) continue;
                    ItemStack remainder = input.extractItem(slot, Math.min(input.getSlotLimit(slot), 8), false);
                    if (!(remainder = networkLookup.insertIntoHandlers(remainder)).isEmpty() && !(remainder = input.insertItem(slot, remainder, false)).isEmpty()) {
                        continue;
                    }
                    break block4;
                }
                break block4;
            }
            if (input == null || this.importItems.isEmpty()) break block4;
            ItemHandlerLookup lookup = new ItemHandlerLookup(List.of(input));
            for (ItemStack stack : this.importItems) {
                ItemStack remainder;
                ItemStack result;
                if (stack == null || stack.isEmpty() || (result = lookup.findAny(stack.getItem(), 8)).isEmpty() || (remainder = networkLookup.insertIntoHandlers(result)).isEmpty()) continue;
                lookup.insertIntoHandlers(remainder);
            }
        }
    }

    IItemHandler getInput() {
        BlockPos outputPos = this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)InterfaceNetworkBlock.FACING)).getOpposite());
        BlockState outputState = this.level.getBlockState(outputPos);
        BlockEntity outputBE = this.level.getBlockEntity(outputPos);
        if (outputState.isAir()) {
            return null;
        }
        return (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.level, outputPos, outputState, outputBE, (Object)Direction.DOWN);
    }

    public List<ItemStack> getImportItems() {
        return this.importItems;
    }

    @Override
    public void onPlayerClick(ItemStack stack, Player player) {
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries);
        tag.put("importItems", (Tag)ItemStack.OPTIONAL_CODEC.listOf().encodeStart((DynamicOps)ops, this.importItems).getOrThrow());
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries);
        if (tag.contains("importItems", 9)) {
            ItemStack.CODEC.listOf().parse((DynamicOps)ops, (Object)tag.get("importItems")).resultOrPartial(error -> System.err.println("Failed to load importItems: " + error)).ifPresent(list -> {
                this.importItems.clear();
                this.importItems.addAll((Collection<ItemStack>)list);
            });
        }
    }

    @Override
    public void openMenu(Player player) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new ImporterMenu(windowId, playerInventory, this.getBlockPos()), (Component)Component.translatable((String)"block.swiss.importer_item_interface")), buf -> {
            buf.writeBlockPos(this.getBlockPos());
            List<NetworkInfo> info = StorageNetworkManager.getInstance().getNetworkInfo((ServerPlayer)player);
            NetworkInfo.LIST_STREAM_CODEC.encode(buf, info);
        });
    }
}

