/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.world.block.entity.item.interfaces;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.mangorage.swiss.StorageNetworkManager;
import org.mangorage.swiss.registry.SWISSBlockEntities;
import org.mangorage.swiss.screen.interfaces.exporter.ExporterMenu;
import org.mangorage.swiss.screen.util.HasMenu;
import org.mangorage.swiss.storage.network.NetworkInfo;
import org.mangorage.swiss.storage.util.IRightClickable;
import org.mangorage.swiss.storage.util.ItemHandlerLookup;
import org.mangorage.swiss.world.block.InterfaceNetworkBlock;
import org.mangorage.swiss.world.block.entity.TickingBlockEntity;
import org.mangorage.swiss.world.block.entity.base.BaseStorageBlockEntity;

public final class ItemExporterBlockEntity
extends BaseStorageBlockEntity
implements TickingBlockEntity,
IRightClickable,
HasMenu {
    private int ticks = 0;
    public final List<ItemStack> exportItems = new ArrayList<ItemStack>();

    public ItemExporterBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)SWISSBlockEntities.EXPORTER_ITEM_INTERFACE_BLOCK_ENTITY.get(), pos, blockState);
    }

    @Override
    public void tickServer() {
        ++this.ticks;
        if (this.ticks % 20 == 0) {
            this.connectToNetwork();
            IItemHandler output = this.getOutput();
            if (output != null) {
                for (ItemStack exportStack : this.exportItems) {
                    ItemStack remainder;
                    ItemHandlerLookup lookup;
                    ItemStack result;
                    if (!ItemHandlerLookup.hasRoom(output, exportStack) || (result = (lookup = ItemHandlerLookup.getLookupForExtract(this.getNetwork())).findAny(exportStack.getItem(), Math.min(exportStack.getMaxStackSize(), 8))).isEmpty() || (remainder = ItemHandlerLookup.insertIntoHandlers(List.of(output), result)).isEmpty()) continue;
                    lookup.insertIntoHandlers(remainder);
                }
            }
        }
    }

    IItemHandler getOutput() {
        BlockPos outputPos = this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)InterfaceNetworkBlock.FACING)).getOpposite());
        BlockState outputState = this.level.getBlockState(outputPos);
        BlockEntity outputBE = this.level.getBlockEntity(outputPos);
        if (outputState.isAir()) {
            return null;
        }
        return (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.level, outputPos, outputState, outputBE, (Object)Direction.DOWN);
    }

    public List<ItemStack> getExportItems() {
        return this.exportItems;
    }

    @Override
    public void onPlayerClick(ItemStack stack, Player player) {
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries);
        tag.put("exportItems", (Tag)ItemStack.OPTIONAL_CODEC.listOf().encodeStart((DynamicOps)ops, this.exportItems).getOrThrow());
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries);
        if (tag.contains("exportItems", 9)) {
            ItemStack.CODEC.listOf().parse((DynamicOps)ops, (Object)tag.get("exportItems")).resultOrPartial(error -> System.err.println("Failed to load exportItems: " + error)).ifPresent(list -> {
                this.exportItems.clear();
                this.exportItems.addAll((Collection<ItemStack>)list);
            });
        }
    }

    @Override
    public void openMenu(Player player) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new ExporterMenu(windowId, playerInventory, this.getBlockPos()), (Component)Component.translatable((String)"block.swiss.exporter_item_interface")), buf -> {
            buf.writeBlockPos(this.getBlockPos());
            List<NetworkInfo> info = StorageNetworkManager.getInstance().getNetworkInfo((ServerPlayer)player);
            NetworkInfo.LIST_STREAM_CODEC.encode(buf, info);
        });
    }
}

