/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.world.block.entity.base;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mangorage.swiss.StorageNetworkManager;
import org.mangorage.swiss.storage.device.IDevice;
import org.mangorage.swiss.storage.device.INetworkHolder;
import org.mangorage.swiss.storage.network.Network;
import org.mangorage.swiss.storage.network.UnknownNetwork;
import org.mangorage.swiss.world.block.InterfaceNetworkBlock;

public abstract class BaseStorageBlockEntity
extends BlockEntity
implements IDevice,
INetworkHolder {
    private UUID networkId = null;
    private UUID owner = null;
    private Network network = UnknownNetwork.INSTANCE;

    public BaseStorageBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        CompoundTag deviceDataTag = new CompoundTag();
        if (this.owner != null) {
            deviceDataTag.putUUID("owner", this.owner);
            if (this.networkId != null) {
                deviceDataTag.putUUID("networkId", this.networkId);
            }
        }
        tag.put("deviceData", (Tag)deviceDataTag);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        CompoundTag deviceDataTag = tag.getCompound("deviceData");
        if (deviceDataTag.contains("owner")) {
            this.setOwner(deviceDataTag.getUUID("owner"));
        }
        this.networkId = deviceDataTag.contains("networkId") ? deviceDataTag.getUUID("networkId") : null;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.getLevel().isClientSide()) {
            this.setNetwork(this.networkId);
        }
    }

    @Override
    public boolean shouldCache() {
        return true;
    }

    protected void connectToNetwork() {
        if (this.owner == null || this.network != UnknownNetwork.INSTANCE) {
            return;
        }
        this.setNetwork(this.getNetworkId());
    }

    @Override
    public Network getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(UUID id) {
        if (this.networkId != id) {
            this.getNetwork().unregisterDevice(this);
        }
        this.network = UnknownNetwork.INSTANCE;
        this.networkId = id;
        this.network = StorageNetworkManager.getInstance().getNetwork(this.getLevel().getServer(), this.getNetworkId());
        this.getNetwork().registerDevice(this);
        if (this.getBlockState().hasProperty((Property)InterfaceNetworkBlock.CONNECTED)) {
            this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)InterfaceNetworkBlock.CONNECTED, (Comparable)Boolean.valueOf(this.getNetwork() != UnknownNetwork.INSTANCE)), 3);
        }
    }

    @Override
    public void setOwner(UUID uuid) {
        this.owner = uuid;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public UUID getNetworkId() {
        return this.networkId;
    }

    @Override
    public boolean isValidDevice() {
        return !this.isRemoved();
    }
}

