/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.world.block;

import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mangorage.swiss.screen.misc.test.TestMenu;
import org.mangorage.swiss.world.block.entity.TickingBlockEntity;
import org.mangorage.swiss.world.block.entity.item.panels.TestBlockEntity;

public final class TestBlock
extends Block
implements EntityBlock {
    private final BiFunction<BlockPos, BlockState, BlockEntity> function;

    public TestBlock(BlockBehaviour.Properties p_49795_, BiFunction<BlockPos, BlockState, BlockEntity> function) {
        super(p_49795_);
        this.function = function;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        if (this.function == null) {
            return null;
        }
        return this.function.apply(blockPos, blockState);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (!level.isClientSide()) {
            TestBlockEntity storageItemPanelBlockEntity = (TestBlockEntity)level.getBlockEntity(blockPos);
            if (storageItemPanelBlockEntity instanceof TestBlockEntity) {
                ContainerData data = storageItemPanelBlockEntity.data;
                player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new TestMenu(windowId, playerInventory, blockPos, data), (Component)Component.literal((String)"TEST")), buf -> buf.writeBlockPos(blockPos));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level1, pos, state1, blockEntity) -> {
            if (blockEntity != null && blockEntity instanceof TickingBlockEntity) {
                TickingBlockEntity tickingBlockEntity = (TickingBlockEntity)blockEntity;
                if (level.isClientSide()) {
                    tickingBlockEntity.tickClient();
                } else {
                    tickingBlockEntity.tickServer();
                }
            }
        };
    }
}

