/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.world.block;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.mangorage.swiss.world.block.AbstractBaseNetworkBlock;

public final class PanelNetworkBlock
extends AbstractBaseNetworkBlock {
    private static final Map<Direction, VoxelShape> SHAPE_CACHE = (Map)Util.make(new EnumMap(Direction.class), map -> {
        double inset = 1.0;
        double extent = 15.0;
        double thickness = 2.0;
        map.put(Direction.NORTH, Block.box((double)inset, (double)inset, (double)(16.0 - thickness), (double)extent, (double)extent, (double)16.0));
        map.put(Direction.SOUTH, Block.box((double)inset, (double)inset, (double)0.0, (double)extent, (double)extent, (double)thickness));
        map.put(Direction.WEST, Block.box((double)(16.0 - thickness), (double)inset, (double)inset, (double)16.0, (double)extent, (double)extent));
        map.put(Direction.EAST, Block.box((double)0.0, (double)inset, (double)inset, (double)thickness, (double)extent, (double)extent));
        map.put(Direction.UP, Block.box((double)inset, (double)0.0, (double)inset, (double)extent, (double)thickness, (double)extent));
        map.put(Direction.DOWN, Block.box((double)inset, (double)(16.0 - thickness), (double)inset, (double)extent, (double)16.0, (double)extent));
    });

    public PanelNetworkBlock(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, BlockEntity> function) {
        super(properties, function);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE_CACHE.get(state.getValue((Property)FACING));
    }
}

