/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.world.block;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.mangorage.swiss.world.block.AbstractBaseNetworkBlock;

public final class InterfaceNetworkBlock
extends AbstractBaseNetworkBlock {
    private static final Map<Direction, VoxelShape> SHAPE_MAP = new EnumMap<Direction, VoxelShape>(Direction.class);
    public static final BooleanProperty CONNECTED;

    private static VoxelShape buildShape(Direction direction) {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.3125, (double)0.84375, (double)0.6875, (double)0.6875, (double)0.90625));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.3125, (double)0.8125, (double)0.6875, (double)0.6875, (double)0.9375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.25, (double)0.9375, (double)0.75, (double)0.75, (double)1.0));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5625, (double)0.75, (double)0.999375, (double)0.625, (double)0.8125, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.75, (double)0.999375, (double)0.4375, (double)0.8125, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.1875, (double)0.999375, (double)0.4375, (double)0.25, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5625, (double)0.1875, (double)0.999375, (double)0.625, (double)0.25, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.5625, (double)0.999375, (double)0.25, (double)0.625, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.375, (double)0.999375, (double)0.25, (double)0.4375, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.5625, (double)0.999375, (double)0.8125, (double)0.625, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.375, (double)0.999375, (double)0.8125, (double)0.4375, (double)0.999375));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.4375, (double)0.75, (double)0.5625, (double)0.5625, (double)0.8125));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.5, (double)0.625, (double)0.6875, (double)0.5, (double)0.75));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.3125, (double)0.625, (double)0.5, (double)0.6875, (double)0.75));
        return InterfaceNetworkBlock.rotateShape(Direction.SOUTH, direction, shape);
    }

    private static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        if (from == to) {
            return shape;
        }
        VoxelShape rotated = Shapes.empty();
        for (AABB box : shape.toAabbs()) {
            double minX = box.minX;
            double minY = box.minY;
            double minZ = box.minZ;
            double maxX = box.maxX;
            double maxY = box.maxY;
            double maxZ = box.maxZ;
            AABB newBox = switch (to) {
                case Direction.NORTH -> new AABB(1.0 - maxX, minY, 1.0 - maxZ, 1.0 - minX, maxY, 1.0 - minZ);
                case Direction.EAST -> new AABB(1.0 - maxZ, minY, minX, 1.0 - minZ, maxY, maxX);
                case Direction.WEST -> new AABB(minZ, minY, 1.0 - maxX, maxZ, maxY, 1.0 - minX);
                case Direction.UP -> new AABB(minX, 1.0 - maxZ, minY, maxX, 1.0 - minZ, maxY);
                case Direction.DOWN -> new AABB(minX, minZ, 1.0 - maxY, maxX, maxZ, 1.0 - minY);
                default -> box;
            };
            rotated = Shapes.or((VoxelShape)rotated, (VoxelShape)Shapes.box((double)newBox.minX, (double)newBox.minY, (double)newBox.minZ, (double)newBox.maxX, (double)newBox.maxY, (double)newBox.maxZ));
        }
        return rotated;
    }

    public InterfaceNetworkBlock(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, BlockEntity> function) {
        super(properties, function);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_MAP.get(state.getValue((Property)FACING));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{CONNECTED});
    }

    static {
        SHAPE_MAP.put(Direction.EAST, InterfaceNetworkBlock.buildShape(Direction.EAST));
        SHAPE_MAP.put(Direction.WEST, InterfaceNetworkBlock.buildShape(Direction.WEST));
        SHAPE_MAP.put(Direction.NORTH, InterfaceNetworkBlock.buildShape(Direction.SOUTH));
        SHAPE_MAP.put(Direction.SOUTH, InterfaceNetworkBlock.buildShape(Direction.NORTH));
        SHAPE_MAP.put(Direction.UP, InterfaceNetworkBlock.buildShape(Direction.UP));
        SHAPE_MAP.put(Direction.DOWN, InterfaceNetworkBlock.buildShape(Direction.DOWN));
        CONNECTED = BlockStateProperties.ENABLED;
    }
}

