/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.storage.util;

import java.util.List;
import java.util.Objects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.mangorage.swiss.storage.device.DeviceType;
import org.mangorage.swiss.storage.device.ItemDevice;
import org.mangorage.swiss.storage.network.Network;

public final class ItemHandlerLookup {
    private final List<IItemHandler> handlers;

    public static boolean hasRoom(IItemHandler handler, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            if (!handler.isItemValid(slot, stack)) continue;
            ItemStack inSlot = handler.getStackInSlot(slot);
            if (inSlot.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)inSlot, (ItemStack)stack)) continue;
            int max = Math.min(inSlot.getMaxStackSize(), handler.getSlotLimit(slot));
            if (inSlot.getCount() >= max) continue;
            return true;
        }
        return false;
    }

    public static ItemStack insertIntoHandlers(List<IItemHandler> handlers, ItemStack inputStack) {
        int slot;
        if (inputStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remaining = inputStack.copy();
        boolean canInsertAnywhere = false;
        block0: for (IItemHandler handler : handlers) {
            for (slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack simulated;
                if (!handler.isItemValid(slot, remaining) || (simulated = handler.insertItem(slot, remaining, true)).equals(remaining)) continue;
                canInsertAnywhere = true;
                break block0;
            }
        }
        if (!canInsertAnywhere) {
            return inputStack;
        }
        for (IItemHandler handler : handlers) {
            for (slot = 0; slot < handler.getSlots(); ++slot) {
                if (!handler.isItemValid(slot, remaining) || !(remaining = handler.insertItem(slot, remaining, false)).isEmpty()) continue;
                return ItemStack.EMPTY;
            }
        }
        return remaining;
    }

    public ItemHandlerLookup(List<IItemHandler> handlers) {
        this.handlers = handlers;
    }

    public static List<IItemHandler> getItemHandlersForInsertNetwork(Network network) {
        return network.getItemDevices().filter(itemDevice -> itemDevice.isValidDevice() && itemDevice.canInsert(DeviceType.ITEM)).map(ItemDevice::getItemHandler).filter(Objects::nonNull).toList();
    }

    public static List<IItemHandler> getItemHandlersForExtractNetwork(Network network) {
        return network.getItemDevices().filter(itemDevice -> itemDevice.isValidDevice() && itemDevice.canExtract(DeviceType.ITEM)).map(ItemDevice::getItemHandler).filter(Objects::nonNull).toList();
    }

    public static ItemHandlerLookup getLookupForExtract(Network network) {
        return new ItemHandlerLookup(ItemHandlerLookup.getItemHandlersForExtractNetwork(network));
    }

    public static ItemHandlerLookup getLookupForInsert(Network network) {
        return new ItemHandlerLookup(ItemHandlerLookup.getItemHandlersForInsertNetwork(network));
    }

    public ItemStack findAny(Item item, int amount) {
        amount = Math.min(amount, item.getDefaultMaxStackSize());
        ItemStack collected = ItemStack.EMPTY;
        int remaining = amount;
        for (IItemHandler handler : this.handlers) {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack simulated = handler.extractItem(slot, remaining, true);
                if (simulated.isEmpty() || simulated.getItem() != item) continue;
                int extractCount = Math.min(simulated.getCount(), remaining);
                ItemStack extracted = handler.extractItem(slot, extractCount, false);
                if (!extracted.isEmpty()) {
                    if (collected.isEmpty()) {
                        collected = extracted.copy();
                    } else {
                        collected.grow(extracted.getCount());
                    }
                    remaining -= extracted.getCount();
                }
                if (remaining <= 0) break;
            }
            if (remaining > 0) continue;
            break;
        }
        return collected;
    }

    public ItemStack insertIntoHandlers(ItemStack stack) {
        return ItemHandlerLookup.insertIntoHandlers(this.handlers, stack);
    }
}

