/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.storage.network;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.mangorage.swiss.storage.network.Permission;

public final class User {
    public static final StreamCodec<FriendlyByteBuf, User> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, u -> u.getUUID().toString(), (StreamCodec)ByteBufCodecs.list().apply(Permission.STREAM_CODEC), u -> u.permissions.stream().toList(), (uuid, list) -> new User((String)uuid, (Set<Permission>)new HashSet<Permission>((Collection<Permission>)list)));
    private final Set<Permission> permissions;
    private final UUID uuid;

    public User(UUID uuid) {
        this.permissions = new HashSet<Permission>();
        this.uuid = uuid;
    }

    User(String uuid, Set<Permission> permissions) {
        this.uuid = UUID.fromString(uuid);
        this.permissions = permissions;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean hasPermission(Set<Permission> permissions) {
        for (Permission permission : permissions) {
            if (!this.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(Permission permission) {
        return this.permissions.contains((Object)permission);
    }

    public void addPermission(Permission permission) {
        this.permissions.add(permission);
    }

    public void removePermission(Permission permission) {
        this.permissions.remove((Object)permission);
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider registries) {
        ListTag permissionsTag = new ListTag();
        for (Permission permission : this.permissions) {
            permissionsTag.add((Object)StringTag.valueOf((String)permission.name()));
        }
        compoundTag.put("permissions", (Tag)permissionsTag);
        compoundTag.putUUID("id", this.uuid);
        return compoundTag;
    }

    public void load(CompoundTag userTag, HolderLookup.Provider registries) {
        ListTag permissionsTag = userTag.getList("permissions", 8);
        for (int id = 0; id < permissionsTag.size(); ++id) {
            String permissionTag = permissionsTag.getString(id);
            this.addPermission(Permission.valueOf(permissionTag));
        }
    }
}

