/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.storage.network;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import org.mangorage.swiss.storage.device.IDevice;
import org.mangorage.swiss.storage.device.ItemDevice;
import org.mangorage.swiss.storage.network.NetworkInfo;
import org.mangorage.swiss.storage.network.Permission;
import org.mangorage.swiss.storage.network.UnknownNetwork;
import org.mangorage.swiss.storage.network.User;

public sealed class Network
permits UnknownNetwork {
    private final Set<ItemDevice> itemDevices = new HashSet<ItemDevice>();
    private final Map<UUID, User> userMap = new HashMap<UUID, User>();
    private final UUID networkId;
    private String networkName = null;
    private boolean dirty = true;

    public Network(UUID networkId) {
        this.networkId = networkId;
    }

    public boolean hasPermission(UUID userId, Set<Permission> permissions) {
        User user = this.userMap.get(userId);
        if (user == null) {
            return false;
        }
        return user.hasPermission(permissions);
    }

    public void addPermission(UUID userId, Set<Permission> permissions) {
        User user = this.userMap.get(userId);
        if (user == null || permissions.isEmpty()) {
            return;
        }
        for (Permission permission : permissions) {
            user.addPermission(permission);
        }
        this.dirty = true;
    }

    public void removePermission(UUID uuid, Set<Permission> permissions) {
        User user = this.userMap.get(uuid);
        if (user == null || permissions.isEmpty()) {
            return;
        }
        for (Permission permission : permissions) {
            user.removePermission(permission);
        }
        this.dirty = true;
    }

    public void setNetworkName(String networkName) {
        this.networkName = networkName;
        this.dirty = true;
    }

    public UUID getId() {
        return this.networkId;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public void registerUser(User user) {
        this.userMap.put(user.getUUID(), user);
        this.dirty = true;
    }

    public void unregisterUser(User user) {
        this.userMap.remove(user.getUUID());
        this.dirty = true;
    }

    public boolean hasUser(UUID userId) {
        return this.userMap.containsKey(userId);
    }

    public void registerDevice(IDevice device) {
        if (device instanceof ItemDevice) {
            ItemDevice itemDevice = (ItemDevice)device;
            this.itemDevices.add(itemDevice);
        }
    }

    public void unregisterDevice(IDevice device) {
        if (device instanceof ItemDevice) {
            ItemDevice itemDevice = (ItemDevice)device;
            this.itemDevices.remove(itemDevice);
        }
    }

    public Stream<ItemDevice> getItemDevices() {
        return this.itemDevices.stream();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public CompoundTag save(CompoundTag network, HolderLookup.Provider registries) {
        this.dirty = false;
        ListTag userTags = new ListTag();
        this.userMap.forEach((id, user) -> userTags.add((Object)user.save(new CompoundTag(), registries)));
        network.put("users", (Tag)userTags);
        network.putString("name", this.networkName);
        return network;
    }

    public void load(CompoundTag networkTag, HolderLookup.Provider registries) {
        ListTag userTags = networkTag.getList("users", 10);
        for (int id = 0; id < userTags.size(); ++id) {
            CompoundTag userTag = userTags.getCompound(id);
            User user = new User(userTag.getUUID("id"));
            user.load(userTag, registries);
            this.userMap.put(user.getUUID(), user);
        }
        this.networkName = networkTag.getString("name");
    }

    public NetworkInfo getInfo(ServerPlayer player) {
        return new NetworkInfo(this.networkName, this.getId(), this.hasUser(player.getUUID()));
    }
}

