/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.screen.panels.storagepanel;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.mangorage.swiss.client.button.Button;
import org.mangorage.swiss.client.button.ButtonStack;
import org.mangorage.swiss.network.MenuInteractPacketC2S;
import org.mangorage.swiss.network.SyncVisibleRowsC2S;
import org.mangorage.swiss.network.request.RequestNetworkItemsPacketC2S;
import org.mangorage.swiss.screen.Buttons;
import org.mangorage.swiss.screen.panels.storagepanel.StoragePanelMenu;
import org.mangorage.swiss.storage.util.IUpdatable;
import org.mangorage.swiss.util.MousePositionManagerUtil;
import org.mangorage.swiss.util.MouseUtil;
import org.mangorage.swiss.util.NumbersUtil;

public final class StoragePanelScreen
extends AbstractContainerScreen<StoragePanelMenu>
implements IUpdatable {
    private EditBox searchBox;
    private List<ItemStack> allItems;
    private List<ItemStack> filteredItems;
    private int scrollIndex = 0;
    private static final int COLUMNS = 9;
    public static int visibleRows = 3;
    private int itemsPerPage;
    private static final int SCROLLBAR_WIDTH = 12;
    private static final int SCROLLBAR_X_OFFSET = 174;
    private static final int SCROLLBAR_Y_OFFSET = 18;
    private boolean isDraggingScrollbar = false;
    private int dragOffsetY = 0;
    private int lastAllItemsSize = -1;
    private String lastSearchText = "";
    private ItemStack selected = ItemStack.EMPTY;
    private int rowButtonX = 0;
    private int rowButtonY = 20;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/item_panel_gui.png");
    private static final ResourceLocation ROW_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/interface_row.png");
    static final ResourceLocation SCROLL_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/interface_scroll.png");
    private final ButtonStack DEFAULT_STORAGE_INTERFACE = new ButtonStack.Builder().add(Buttons.DEFAULT_INTERFACE).addButton(new Button(ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/button_row.png"), 0, 42, 0, 0, 17, 17, 17, 17, this::cycleVisibleRows, (guiGraphics, font, mouseX, mouseY, x, y) -> guiGraphics.renderTooltip(font, (Component)Component.translatable((String)"gui.swiss.row_menu"), mouseX, mouseY))).build();

    public StoragePanelScreen(StoragePanelMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.itemsPerPage = visibleRows * 9;
        this.allItems = this.getAllItems();
        this.filteredItems = new ArrayList<ItemStack>(this.allItems);
        this.imageHeight = 175 + (visibleRows - 3) * 18;
        this.imageWidth = 209;
        this.inventoryLabelY = this.imageHeight - 98;
        this.inventoryLabelX = 25;
        this.titleLabelX = 25;
        this.lastSearchText = "";
    }

    @Override
    public void update() {
        List<ItemStack> newAllItems = this.getAllItems();
        this.allItems = newAllItems;
        this.onSearchChanged(this.searchBox != null ? this.searchBox.getValue() : "");
    }

    public List<ItemStack> getAllItems() {
        return ((StoragePanelMenu)this.menu).itemStacks;
    }

    private int calculateMaxRows() {
        int windowHeight = this.minecraft.getWindow().getGuiScaledHeight();
        int topSectionHeight = 72;
        int bottomSectionHeight = 101;
        int searchBoxHeight = 52;
        int margin = 10;
        int availableHeight = windowHeight - topSectionHeight - bottomSectionHeight - searchBoxHeight - margin * 2;
        int maxRows = availableHeight / 18;
        return Math.max(3, maxRows);
    }

    private void cycleVisibleRows(int button) {
        int maxRows = this.calculateMaxRows();
        int currentRows = visibleRows;
        if (button == 0) {
            if (++currentRows > maxRows) {
                currentRows = 3;
            }
        } else if (button == 1 && --currentRows < 3) {
            currentRows = maxRows;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncVisibleRowsC2S(currentRows, 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ((StoragePanelMenu)this.menu).player.getPersistentData().putInt("swiss_visible_rows", currentRows);
        ((StoragePanelMenu)this.menu).visibleRows = currentRows;
        visibleRows = currentRows;
        this.updateGuiLayout();
    }

    private void updateGuiLayout() {
        this.itemsPerPage = visibleRows * 9;
        this.imageHeight = 175 + (visibleRows - 3) * 18;
        this.inventoryLabelY = this.imageHeight - 98;
        assert (this.minecraft != null);
        this.topPos = (this.minecraft.getWindow().getGuiScaledHeight() - this.imageHeight) / 2;
        this.scrollIndex = 0;
        this.init();
    }

    public void onClose() {
        super.onClose();
        MousePositionManagerUtil.clear();
    }

    protected void init() {
        super.init();
        MousePositionManagerUtil.setLastKnownPosition();
        this.clearWidgets();
        ((StoragePanelMenu)this.menu).slots.clear();
        this.searchBox = new EditBox(this.font, this.leftPos + 86 + 37, this.topPos + 3, 80, 14, (Component)Component.literal((String)"Search"));
        this.searchBox.setResponder(this::onSearchChanged);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        assert (this.minecraft != null);
        assert (this.minecraft.player != null);
        ((StoragePanelMenu)this.menu).addPlayerInventory(this.minecraft.player.getInventory());
        ((StoragePanelMenu)this.menu).addPlayerHotbar(this.minecraft.player.getInventory());
        this.onSearchChanged(this.searchBox.getValue());
    }

    private void onSearchChanged(String text) {
        if (!text.equals(this.lastSearchText)) {
            this.lastSearchText = text;
            this.scrollIndex = 0;
        }
        this.filteredItems = this.combineItemStacks(this.allItems.stream().filter(stack -> stack.getHoverName().getString().toLowerCase().contains(text.toLowerCase())).toList());
    }

    private List<ItemStack> combineItemStacks(List<ItemStack> input) {
        LinkedHashMap<CallSite, ItemStack> combinedMap = new LinkedHashMap<CallSite, ItemStack>();
        for (ItemStack stack : input) {
            if (stack.isEmpty()) continue;
            String key = stack.getItem().getDescriptionId() + "|" + stack.getDamageValue() + "|" + String.valueOf(stack.getComponents());
            if (combinedMap.containsKey(key)) {
                ((ItemStack)combinedMap.get(key)).grow(stack.getCount());
                continue;
            }
            combinedMap.put((CallSite)((Object)key), stack.copy());
        }
        return new ArrayList<ItemStack>(combinedMap.values());
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int baseHeight = 72;
        int tileHeight = 18;
        int extraRows = visibleRows - 3;
        int slotRowWidth = 162;
        int slotRowHeight = 18;
        int startX = this.leftPos + 24;
        int startY = this.topPos + 19;
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, baseHeight);
        int tileSourceX = 0;
        int tileSourceY = 54;
        int tileWidth = 209;
        for (int i = 0; i < extraRows; ++i) {
            int drawY = this.topPos + baseHeight + i * tileHeight;
            guiGraphics.blit(TEXTURE, this.leftPos, drawY, tileSourceX, tileSourceY, tileWidth, tileHeight);
        }
        int bottomSourceY = baseHeight + tileHeight - 18;
        int bottomDestY = this.topPos + baseHeight + extraRows * tileHeight;
        int bottomHeight = 101;
        guiGraphics.blit(TEXTURE, this.leftPos, bottomDestY, 0, bottomSourceY, this.imageWidth, bottomHeight);
        int scrollbarX = this.leftPos + 174 + 17;
        int scrollbarY = this.topPos + 18;
        int handleHeight = 15;
        int maxScroll = Math.max(0, this.filteredItems.size() - this.itemsPerPage);
        if (maxScroll > 0) {
            float scrollPercent = (float)this.scrollIndex / (float)maxScroll;
            int handleY = scrollbarY + (int)((float)(this.getScrollbarHeight() - handleHeight) * scrollPercent);
            guiGraphics.blit(SCROLL_SPRITE, scrollbarX, handleY + 2, 168.0f, 0.0f, 12, handleHeight, 12, 15);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ROW_SPRITE);
        for (int i = 0; i < visibleRows; ++i) {
            int y = startY + i * slotRowHeight;
            guiGraphics.blit(ROW_SPRITE, startX, y, 0.0f, 0.0f, slotRowWidth, slotRowHeight, slotRowWidth, slotRowHeight);
        }
        this.DEFAULT_STORAGE_INTERFACE.blit(guiGraphics, this.leftPos, this.topPos);
    }

    private int getScrollbarHeight() {
        return 18 * visibleRows;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int index;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.searchBox.render(guiGraphics, mouseX, mouseY, partialTicks);
        int startX = this.leftPos + 25;
        int startY = this.topPos + 20;
        for (int i = 0; i < this.itemsPerPage && (index = this.scrollIndex + i) < this.filteredItems.size(); ++i) {
            ItemStack stack = this.filteredItems.get(index);
            int row = i / 9;
            int col = i % 9;
            int x = startX + col * 18;
            int y = startY + row * 18;
            if (mouseX >= x && mouseX < x + 16 && mouseY >= y && mouseY < y + 16) {
                guiGraphics.renderTooltip(this.font, stack, mouseX, mouseY);
                this.selected = stack;
            } else {
                this.selected = ItemStack.EMPTY;
            }
            guiGraphics.renderItem(stack, x, y);
            if (stack.getCount() == 1) {
                guiGraphics.renderItemDecorations(this.font, stack, x, y);
            }
            StoragePanelScreen.renderAmount(guiGraphics, x, y, NumbersUtil.format(stack.getCount()), 0xFFFFFF);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.DEFAULT_STORAGE_INTERFACE.renderButtonTooltips(guiGraphics, this.font, mouseX, mouseY, this.leftPos, this.topPos);
    }

    public static void renderAmount(GuiGraphics graphics, int x, int y, String text, int color) {
        StoragePanelScreen.renderAmount(graphics, x, y, text, color, text.length() <= 3);
    }

    public static void renderAmount(GuiGraphics graphics, int x, int y, String text, int color, boolean large) {
        Font font = Minecraft.getInstance().font;
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)x + (large ? 1.0 : 0.0), (double)y + (large ? 1.0 : 0.0), 300.0);
        if (!large) {
            poseStack.scale(0.5f, 0.5f, 1.0f);
        }
        graphics.drawString(font, text, (large ? 16 : 30) - font.width(text), large ? 8 : 22, color, true);
        poseStack.popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        MousePositionManagerUtil.getLastKnownPosition();
        int startX = this.leftPos + 25;
        int startY = this.topPos + 20;
        int slotSize = 18;
        if (button == 1 && this.searchBox != null && this.searchBox.isMouseOver(mouseX, mouseY)) {
            this.searchBox.setValue("");
            this.onSearchChanged("");
            return true;
        }
        if (button == 0 && this.searchBox != null && !this.searchBox.isMouseOver(mouseX, mouseY)) {
            this.searchBox.setFocused(false);
        }
        this.DEFAULT_STORAGE_INTERFACE.mouseClicked((int)mouseX, (int)mouseY, button, this.leftPos, this.topPos);
        for (int i = 0; i < this.itemsPerPage; ++i) {
            int index = this.scrollIndex + i;
            int row = i / 9;
            int col = i % 9;
            int x = startX + col * slotSize;
            int y = startY + row * slotSize;
            if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 16)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 16))) continue;
            if (index < this.filteredItems.size()) {
                ItemStack stack = this.filteredItems.get(index);
                if (!stack.isEmpty()) {
                    assert (Minecraft.getInstance().player != null);
                    Minecraft.getInstance().player.connection.send((CustomPacketPayload)new MenuInteractPacketC2S(stack, ClickType.PICKUP.ordinal(), 4));
                }
            } else {
                assert (Minecraft.getInstance().player != null);
                Minecraft.getInstance().player.connection.send((CustomPacketPayload)new MenuInteractPacketC2S(ItemStack.EMPTY, ClickType.PICKUP.ordinal(), 4));
            }
            return true;
        }
        int scrollbarX = this.leftPos + 174 + 17;
        int scrollbarY = this.topPos + 18;
        int handleHeight = 15;
        int maxScroll = Math.max(0, this.filteredItems.size() - this.itemsPerPage);
        if (maxScroll > 0) {
            float scrollPercent = (float)this.scrollIndex / (float)maxScroll;
            int handleY = scrollbarY + (int)((float)(this.getScrollbarHeight() - handleHeight) * scrollPercent);
            if (MouseUtil.isMouseOver(mouseX, mouseY, scrollbarX, handleY, 12, handleHeight)) {
                this.isDraggingScrollbar = true;
                this.dragOffsetY = (int)mouseY - handleY;
                return true;
            }
            this.isDraggingScrollbar = false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void containerTick() {
        if (Minecraft.getInstance().player != null) {
            Minecraft.getInstance().player.connection.send((CustomPacketPayload)RequestNetworkItemsPacketC2S.INSTANCE);
            Minecraft.getInstance().player.connection.send((CustomPacketPayload)RequestNetworkItemsPacketC2S.INSTANCE);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.searchBox != null && this.searchBox.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        int maxScroll = Math.max(0, this.filteredItems.size() - this.itemsPerPage);
        int maxScrollRowStart = maxScroll < 9 ? maxScroll : maxScroll / 9 * 9;
        int newScrollIndex = this.scrollIndex - (int)scrollY * 9;
        if ((newScrollIndex = Mth.clamp((int)newScrollIndex, (int)0, (int)maxScrollRowStart)) != this.scrollIndex) {
            this.scrollIndex = newScrollIndex;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingScrollbar) {
            int scrollbarY = this.topPos + 18;
            int handleHeight = 15;
            int maxScroll = Math.max(0, this.filteredItems.size() - this.itemsPerPage);
            int relativeY = (int)mouseY - scrollbarY - this.dragOffsetY;
            float scrollbarHeight = this.getScrollbarHeight() - handleHeight;
            float percent = Mth.clamp((float)((float)relativeY / scrollbarHeight), (float)0.0f, (float)1.0f);
            int rawIndex = (int)(percent * (float)maxScroll);
            this.scrollIndex = Mth.clamp((int)(rawIndex / 9 * 9), (int)0, (int)maxScroll);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.searchBox.isFocused() && (this.searchBox.keyPressed(keyCode, scanCode, modifiers) || this.searchBox.canConsumeInput())) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

