/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.screen.panels.storagepanel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.mangorage.swiss.StorageNetworkManager;
import org.mangorage.swiss.network.SyncNetworkItemsPacketS2C;
import org.mangorage.swiss.registry.SWISSBlocks;
import org.mangorage.swiss.screen.MSMenuTypes;
import org.mangorage.swiss.screen.interfaces.config_block.ConfigureBlockNetworkMenu;
import org.mangorage.swiss.screen.misc.setting.SettingsMenu;
import org.mangorage.swiss.screen.util.Interact;
import org.mangorage.swiss.storage.device.DeviceType;
import org.mangorage.swiss.storage.device.INetworkHolder;
import org.mangorage.swiss.storage.device.ItemDevice;
import org.mangorage.swiss.storage.network.ISyncableNetworkHandler;
import org.mangorage.swiss.storage.network.Network;
import org.mangorage.swiss.storage.network.NetworkInfo;
import org.mangorage.swiss.storage.network.Permission;
import org.mangorage.swiss.storage.util.IPacketRequest;
import org.mangorage.swiss.storage.util.ItemHandlerLookup;
import org.mangorage.swiss.world.block.entity.item.panels.StorageItemPanelBlockEntity;

public final class StoragePanelMenu
extends AbstractContainerMenu
implements ISyncableNetworkHandler,
IPacketRequest,
Interact {
    private INetworkHolder networkHolder;
    List<ItemStack> itemStacks = List.of();
    private Level level;
    public Player player;
    private BlockPos blockPos;
    public int visibleRows;
    private StorageItemPanelBlockEntity blockEntity;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 3;

    public StoragePanelMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos());
    }

    public StoragePanelMenu(int containerID, Inventory inventory, BlockPos blockPos) {
        super((MenuType)MSMenuTypes.STORAGE_MENU.get(), containerID);
        INetworkHolder holder;
        this.player = inventory.player;
        this.blockPos = blockPos;
        this.level = inventory.player.level();
        BlockEntity blockEntity = this.level.getBlockEntity(blockPos);
        this.networkHolder = blockEntity instanceof INetworkHolder ? (holder = (INetworkHolder)blockEntity) : null;
        this.blockEntity = (StorageItemPanelBlockEntity)this.level.getBlockEntity(blockPos);
        int rows = this.player.getPersistentData().getInt("swiss_visible_rows");
        this.visibleRows = rows == 0 ? 3 : rows;
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
    }

    List<ItemStack> getNetworkItems() {
        return this.networkHolder.getNetwork().getItemDevices().filter(device -> device.isValidDevice() && device.canExtract(DeviceType.ITEM)).map(ItemDevice::getItemHandler).filter(Objects::nonNull).map(handler -> {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                stacks.add(handler.getStackInSlot(slot).copy());
            }
            return stacks;
        }).flatMap(Collection::stream).filter(item -> !item.isEmpty()).toList();
    }

    public void sendAllDataToRemote() {
        super.sendAllDataToRemote();
        if (!this.level.isClientSide()) {
            List<ItemStack> items = this.getNetworkItems();
            ServerPlayer sp = (ServerPlayer)this.player;
            sp.connection.send((CustomPacketPayload)new SyncNetworkItemsPacketS2C(items));
        }
    }

    public boolean clickMenuButton(Player player, int id) {
        return super.clickMenuButton(player, id);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack originalStack = sourceStack.copy();
        if (!playerIn.level().isClientSide()) {
            if (index < 36) {
                ItemHandlerLookup insertHandler = ItemHandlerLookup.getLookupForInsert(this.networkHolder.getNetwork());
                ItemStack leftover = insertHandler.insertIntoHandlers(sourceStack);
                if (leftover.isEmpty()) {
                    sourceSlot.set(ItemStack.EMPTY);
                } else {
                    sourceSlot.set(leftover);
                }
                sourceSlot.setChanged();
                return ItemStack.EMPTY;
            }
            if (index >= 36 && index < 39) {
                if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                    return ItemStack.EMPTY;
                }
                if (sourceStack.isEmpty()) {
                    sourceSlot.set(ItemStack.EMPTY);
                } else {
                    sourceSlot.setChanged();
                }
                return originalStack;
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return StoragePanelMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.blockPos), (Player)player, (Block)((Block)SWISSBlocks.STORAGE_ITEM_PANEL_BLOCK.get()));
    }

    public void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18 + 17, 36 + this.visibleRows * 18 + i * 18));
            }
        }
    }

    public void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18 + 17, 94 + this.visibleRows * 18));
        }
    }

    @Override
    public void sync(Object object) {
        if (object instanceof ItemList) {
            ItemList itemList = (ItemList)object;
            try {
                List<ItemStack> list;
                List<ItemStack> stacks = list = itemList.stacks();
                this.itemStacks = stacks;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    @Override
    public void requested(ServerPlayer player) {
        List<ItemStack> items = this.getNetworkItems();
        player.connection.send((CustomPacketPayload)new SyncNetworkItemsPacketS2C(items));
    }

    boolean hasPermission(Network network, Set<Permission> permissions) {
        return network.hasPermission(this.player.getUUID(), permissions);
    }

    @Override
    public void clicked(ItemStack itemStack, CompoundTag extraData, ClickType clickType, int button) {
        if (button == 1) {
            this.player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new SettingsMenu(windowId, playerInventory, this.blockPos), (Component)Component.translatable((String)"gui.swiss.configure_block_network")), buf -> buf.writeBlockPos(this.blockPos));
        } else if (button == 2) {
            this.player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new ConfigureBlockNetworkMenu(windowId, playerInventory, this.blockPos), (Component)Component.translatable((String)"gui.swiss.configure_block_network")), buf -> {
                buf.writeBlockPos(this.blockPos);
                NetworkInfo.LIST_STREAM_CODEC.encode(buf, StorageNetworkManager.getInstance().getNetworkInfo((ServerPlayer)this.player));
            });
        } else if (button == 3) {
            this.player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new SettingsMenu(windowId, playerInventory, this.blockPos), (Component)Component.translatable((String)"gui.swiss.settings_menu")), buf -> buf.writeBlockPos(this.blockPos));
        } else if (button == 4 && clickType == ClickType.PICKUP) {
            if (this.getCarried().isEmpty() && itemStack != null) {
                if (!this.hasPermission(this.networkHolder.getNetwork(), Set.of(Permission.OWNER, Permission.ADMIN, Permission.CAN_EXTRACT))) {
                    this.player.sendSystemMessage((Component)Component.literal((String)"No Permission to extract from storage!"));
                    return;
                }
                ItemHandlerLookup lookup = ItemHandlerLookup.getLookupForExtract(this.networkHolder.getNetwork());
                ItemStack result = lookup.findAny(itemStack.getItem(), Math.min(itemStack.getCount(), itemStack.getMaxStackSize()));
                if (!result.isEmpty()) {
                    this.setCarried(result);
                }
            } else if (!this.getCarried().isEmpty()) {
                if (!this.hasPermission(this.networkHolder.getNetwork(), Set.of(Permission.OWNER, Permission.ADMIN, Permission.CAN_INSERT))) {
                    this.player.sendSystemMessage((Component)Component.literal((String)"No Permission to insert into storage!"));
                    return;
                }
                ItemStack stack = this.getCarried();
                ItemHandlerLookup lookup = ItemHandlerLookup.getLookupForInsert(this.networkHolder.getNetwork());
                ItemStack remainder = lookup.insertIntoHandlers(stack);
                if (remainder.isEmpty()) {
                    this.setCarried(ItemStack.EMPTY);
                } else {
                    this.setCarried(remainder);
                }
            }
        }
    }

    public record ItemList(List<ItemStack> stacks) {
    }
}

