/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.screen.misc.test;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.mangorage.swiss.network.SyncNetworkItemsPacketS2C;
import org.mangorage.swiss.registry.SWISSBlocks;
import org.mangorage.swiss.screen.MSMenuTypes;
import org.mangorage.swiss.storage.network.ISyncableNetworkHandler;
import org.mangorage.swiss.world.block.entity.item.panels.TestBlockEntity;

public final class TestMenu
extends AbstractContainerMenu
implements ISyncableNetworkHandler {
    private TestBlockEntity blockEntity;
    List<ItemStack> itemStacks = List.of();
    private Level level;
    private ContainerData data;
    private Player player;
    private BlockPos blockPos;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 3;

    public TestMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos(), (ContainerData)new SimpleContainerData(1));
    }

    public TestMenu(int containerID, Inventory inventory, BlockPos blockPos, ContainerData data) {
        super((MenuType)MSMenuTypes.TEST_MENU.get(), containerID);
        this.player = inventory.player;
        this.blockPos = blockPos;
        this.level = inventory.player.level();
        this.data = data;
        this.blockEntity = (TestBlockEntity)this.level.getBlockEntity(blockPos);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        for (int slots = 0; slots < 9; ++slots) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getItemStackHandler(), slots, 8 + slots * 18, 20));
        }
        this.addDataSlots(data);
    }

    public void sendAllDataToRemote() {
        super.sendAllDataToRemote();
        if (!this.level.isClientSide()) {
            List<ItemStack> items = this.blockEntity.getItems();
            ServerPlayer sp = (ServerPlayer)this.player;
            sp.connection.send((CustomPacketPayload)new SyncNetworkItemsPacketS2C(items));
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 39) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return TestMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.blockPos), (Player)player, (Block)((Block)SWISSBlocks.TEST_BLOCK.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    @Override
    public void sync(Object object) {
        if (object instanceof ItemList) {
            ItemList itemList = (ItemList)object;
            try {
                List<ItemStack> list;
                List<ItemStack> stacks = list = itemList.stacks();
                this.itemStacks = stacks;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    public record ItemList(List<ItemStack> stacks) {
    }
}

