/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.screen.misc.setting;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.mangorage.swiss.network.MenuInteractPacketC2S;
import org.mangorage.swiss.screen.misc.setting.SettingsMenu;
import org.mangorage.swiss.storage.device.INetworkHolder;
import org.mangorage.swiss.storage.util.IUpdatable;
import org.mangorage.swiss.util.MousePositionManagerUtil;
import org.mangorage.swiss.util.MouseUtil;

public final class SettingsScreen
extends AbstractContainerScreen<SettingsMenu>
implements IUpdatable {
    private int networkButtonX = 10;
    private int networkButtonY = 22;
    private int managerButtonX = 32;
    private int managerButtonY = 22;
    private int blockSettingsX = 54;
    private int blockSettingsY = 22;
    private BlockPos menuOpenPosition;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/settings_gui.png");
    static final ResourceLocation NETWORK_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/button_network.png");
    static final ResourceLocation MANAGER_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/button_manager.png");
    static final ResourceLocation BLOCK_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/button_block.png");
    static final ResourceLocation SCROLL_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/interface_scroll.png");

    public SettingsScreen(SettingsMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.imageHeight = 165;
        this.imageWidth = 175;
    }

    @Override
    public void update() {
    }

    public void onClose() {
        super.onClose();
        MousePositionManagerUtil.clear();
    }

    protected void init() {
        super.init();
        MousePositionManagerUtil.setLastKnownPosition();
        this.menuOpenPosition = ((SettingsMenu)this.menu).getBlockPos();
    }

    public BlockEntity getBlockEntity() {
        return ((SettingsMenu)this.menu).getLevel().getBlockEntity(this.menuOpenPosition);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.blit(NETWORK_BUTTON, this.leftPos + this.networkButtonX, this.topPos + this.networkButtonY, 0.0f, 0.0f, 17, 17, 17, 17);
        guiGraphics.blit(MANAGER_BUTTON, this.leftPos + this.managerButtonX, this.topPos + this.managerButtonY, 0.0f, 0.0f, 17, 17, 17, 17);
        if (this.getBlockEntity() instanceof INetworkHolder) {
            guiGraphics.blit(BLOCK_BUTTON, this.leftPos + this.blockSettingsX, this.topPos + this.blockSettingsY, 0.0f, 0.0f, 17, 17, 17, 17);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderButtonTooltips(guiGraphics, mouseX, mouseY, this.leftPos, this.topPos);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        MousePositionManagerUtil.getLastKnownPosition();
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, this.leftPos + this.networkButtonX, this.topPos + this.networkButtonY, 0, 0, 17, 17)) {
            Minecraft.getInstance().getConnection().send((CustomPacketPayload)new MenuInteractPacketC2S(ItemStack.EMPTY, 0, 1));
        }
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, this.leftPos + this.managerButtonX, this.topPos + this.managerButtonY, 0, 0, 17, 17)) {
            Minecraft.getInstance().getConnection().send((CustomPacketPayload)new MenuInteractPacketC2S(ItemStack.EMPTY, 0, 2));
        }
        if (this.getBlockEntity() instanceof INetworkHolder && MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, this.leftPos + this.blockSettingsX, this.topPos + this.blockSettingsY, 0, 0, 17, 17)) {
            Minecraft.getInstance().getConnection().send((CustomPacketPayload)new MenuInteractPacketC2S(ItemStack.EMPTY, 0, 3));
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void renderButtonTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, this.networkButtonX, this.networkButtonY, 17, 17)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.swiss.network_settings"), mouseX, mouseY);
        }
        if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, this.managerButtonX, this.managerButtonY, 17, 17)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.swiss.create_join_network_settings"), mouseX, mouseY);
        }
        if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, this.blockSettingsX, this.blockSettingsY, 17, 17)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.swiss.configure_block_network"), mouseX, mouseY);
        }
    }
}

