/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.screen.misc.setting;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.mangorage.swiss.StorageNetworkManager;
import org.mangorage.swiss.screen.MSMenuTypes;
import org.mangorage.swiss.screen.interfaces.config_block.ConfigureBlockNetworkMenu;
import org.mangorage.swiss.screen.misc.manager.ManagerMenu;
import org.mangorage.swiss.screen.misc.network.NetworkMenu;
import org.mangorage.swiss.screen.util.Interact;
import org.mangorage.swiss.storage.network.ISyncableNetworkHandler;
import org.mangorage.swiss.storage.network.NetworkInfo;
import org.mangorage.swiss.storage.util.IPacketRequest;

public final class SettingsMenu
extends AbstractContainerMenu
implements ISyncableNetworkHandler,
IPacketRequest,
Interact {
    List<ItemStack> itemStacks = List.of();
    private Level level;
    private Player player;
    private final BlockPos blockPos;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 3;

    public SettingsMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos());
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public Level getLevel() {
        return this.level;
    }

    public SettingsMenu(int containerID, Inventory inventory, BlockPos blockPos) {
        super((MenuType)MSMenuTypes.SETTINGS_MENU.get(), containerID);
        this.player = inventory.player;
        this.blockPos = blockPos;
        this.level = inventory.player.level();
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
    }

    public void sendAllDataToRemote() {
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 39) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    @Override
    public void clicked(ItemStack itemStack, CompoundTag extraData, ClickType clickType, int button) {
        if (button == 1) {
            this.player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new NetworkMenu(windowId, playerInventory, this.blockPos), (Component)Component.translatable((String)"gui.swiss.network_menu_title")), buf -> {
                buf.writeBlockPos(this.blockPos);
                List<NetworkInfo> info = StorageNetworkManager.getInstance().getNetworkInfo((ServerPlayer)this.player);
                NetworkInfo.LIST_STREAM_CODEC.encode(buf, info);
            });
        }
        if (button == 2) {
            this.player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new ManagerMenu(windowId, playerInventory, this.blockPos), (Component)Component.literal((String)"")), buf -> {
                buf.writeBlockPos(this.blockPos);
                List<NetworkInfo> info = StorageNetworkManager.getInstance().getNetworkInfo((ServerPlayer)this.player);
                NetworkInfo.LIST_STREAM_CODEC.encode(buf, info);
            });
        }
        if (button == 3) {
            this.player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new ConfigureBlockNetworkMenu(windowId, playerInventory, this.blockPos), (Component)Component.translatable((String)"gui.swiss.configure_block_network")), buf -> {
                buf.writeBlockPos(this.blockPos);
                List<NetworkInfo> info = StorageNetworkManager.getInstance().getNetworkInfo((ServerPlayer)this.player);
                NetworkInfo.LIST_STREAM_CODEC.encode(buf, info);
            });
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    @Override
    public void sync(Object object) {
        if (object instanceof ItemList) {
            ItemList itemList = (ItemList)object;
            try {
                List<ItemStack> list;
                List<ItemStack> stacks = list = itemList.stacks();
                this.itemStacks = stacks;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    @Override
    public void requested(ServerPlayer player) {
    }

    public record ItemList(List<ItemStack> stacks) {
    }
}

