/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.screen.misc.network;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.mangorage.swiss.screen.misc.network.NetworkMenu;
import org.mangorage.swiss.storage.util.IUpdatable;
import org.mangorage.swiss.util.MousePositionManagerUtil;

public final class NetworkScreen
extends AbstractContainerScreen<NetworkMenu>
implements IUpdatable {
    private final List<String> stringList = List.of("network1", "network2", "network3", "network4", "network5", "network6");
    private int scrollOffset = 0;
    private final int maxVisibleLines = 3;
    private final int lineHeight = 12;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/settings_gui.png");

    public NetworkScreen(NetworkMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.imageHeight = 165;
        this.imageWidth = 175;
    }

    @Override
    public void update() {
    }

    protected void init() {
        super.init();
        MousePositionManagerUtil.setLastKnownPosition();
    }

    public void onClose() {
        super.onClose();
        MousePositionManagerUtil.clear();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int x = this.leftPos + 10;
        int y = this.topPos + 30;
        int listSize = this.stringList.size();
        int end = Math.min(this.scrollOffset + 3, listSize);
        for (int i = this.scrollOffset; i < end; ++i) {
            guiGraphics.drawString(this.font, this.stringList.get(i), x, y + (i - this.scrollOffset) * 12, 0xFFFFFF);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        MousePositionManagerUtil.getLastKnownPosition();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int maxOffset = Math.max(0, this.stringList.size() - 3);
        if (scrollY < 0.0) {
            this.scrollOffset = Math.min(this.scrollOffset + 1, maxOffset);
        } else if (scrollY > 0.0) {
            this.scrollOffset = Math.max(this.scrollOffset - 1, 0);
        }
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

