/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.screen.misc.manager;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.mangorage.swiss.network.CreateNetworkPacketC2S;
import org.mangorage.swiss.network.JoinNetworkPacketC2S;
import org.mangorage.swiss.screen.misc.manager.ManagerMenu;
import org.mangorage.swiss.screen.misc.manager.ManagerModes;
import org.mangorage.swiss.storage.network.NetworkInfo;
import org.mangorage.swiss.storage.util.IUpdatable;
import org.mangorage.swiss.util.MousePositionManagerUtil;
import org.mangorage.swiss.util.MouseUtil;

public final class ManagerScreen
extends AbstractContainerScreen<ManagerMenu>
implements IUpdatable {
    private EditBox createNetworkNameEditBox;
    private EditBox createNetworkPasswordEditBox;
    private EditBox joinNetworkPasswordEditBox;
    public int textAdjust = 8;
    private int networkScrollIndex = 0;
    private final int VISIBLE_NETWORKS = 3;
    private NetworkInfo selectedNetwork;
    private List<NetworkInfo> knownNetworks = List.of();
    private int managerButtonX = 155;
    private int managerButtonY = 4;
    private int confirmButtonX = 155;
    private int confirmButtonY = 55;
    private boolean draggingScrollBar = false;
    private int dragOffsetY = 0;
    private ManagerModes managerModes = ManagerModes.CREATE;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/settings_gui.png");
    private static final ResourceLocation BUTTON_JOIN = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/button_manager_join.png");
    private static final ResourceLocation BUTTON_CREATE = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/button_manager_create.png");
    private static final ResourceLocation BUTTON_CONFIRM = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/button_confirm.png");
    static final ResourceLocation SCROLL_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/interface_scroll.png");

    public ManagerScreen(ManagerMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.imageHeight = 165;
        this.imageWidth = 175;
        this.knownNetworks = menu.networkInfo;
    }

    @Override
    public void update() {
    }

    public void onClose() {
        super.onClose();
        MousePositionManagerUtil.clear();
    }

    protected void init() {
        super.init();
        MousePositionManagerUtil.setLastKnownPosition();
        this.clearWidgets();
        if (this.managerModes == ManagerModes.CREATE) {
            this.createNetworkNameEditBox = new EditBox(this.font, this.leftPos + this.textAdjust, this.topPos + 28, 117, 14, (Component)Component.translatable((String)"gui.swiss.name"));
            this.addRenderableWidget((GuiEventListener)this.createNetworkNameEditBox);
            this.createNetworkPasswordEditBox = new EditBox(this.font, this.leftPos + this.textAdjust, this.topPos + 56, 117, 14, (Component)Component.translatable((String)"gui.swiss.password"));
            this.addRenderableWidget((GuiEventListener)this.createNetworkPasswordEditBox);
        }
        if (this.managerModes == ManagerModes.JOIN) {
            this.joinNetworkPasswordEditBox = new EditBox(this.font, this.leftPos + this.textAdjust, this.topPos + 56, 117, 14, (Component)Component.translatable((String)"gui.swiss.join_password"));
            this.addRenderableWidget((GuiEventListener)this.joinNetworkPasswordEditBox);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.managerModes == ManagerModes.CREATE) {
            guiGraphics.blit(BUTTON_CREATE, this.leftPos + this.managerButtonX, this.topPos + this.managerButtonY, 0.0f, 0.0f, 17, 17, 17, 17);
        }
        if (this.managerModes == ManagerModes.JOIN) {
            guiGraphics.blit(BUTTON_JOIN, this.leftPos + this.managerButtonX, this.topPos + this.managerButtonY, 0.0f, 0.0f, 17, 17, 17, 17);
        }
        guiGraphics.blit(BUTTON_CONFIRM, this.leftPos + this.confirmButtonX, this.topPos + this.confirmButtonY, 0.0f, 0.0f, 17, 17, 17, 17);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.managerModes == ManagerModes.CREATE) {
            this.createNetworkNameEditBox.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.createNetworkPasswordEditBox.render(guiGraphics, mouseX, mouseY, partialTicks);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.swiss.create_network"), this.leftPos + this.textAdjust, this.topPos + 6, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.swiss.set_name"), this.leftPos + this.textAdjust, this.topPos + 18, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.swiss.set_password"), this.leftPos + this.textAdjust, this.topPos + 46, 0x404040, false);
        }
        if (this.managerModes == ManagerModes.JOIN) {
            this.joinNetworkPasswordEditBox.render(guiGraphics, mouseX, mouseY, partialTicks);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.swiss.join_network"), this.leftPos + this.textAdjust, this.topPos + 6, 0x404040, false);
            int listX = this.leftPos + this.textAdjust + 3;
            int listY = this.topPos + 22;
            int listWidth = 100;
            Objects.requireNonNull(this.font);
            int listHeight = (9 + 2) * 3;
            guiGraphics.fill(listX - 2, listY - 2, listX + listWidth, listY + listHeight, -2236963);
            guiGraphics.fill(listX - 3, listY - 3, listX + listWidth + 1, listY - 2, -16777216);
            guiGraphics.fill(listX - 3, listY + listHeight, listX + listWidth + 1, listY + listHeight + 1, -16777216);
            guiGraphics.fill(listX - 3, listY - 2, listX - 2, listY + listHeight, -16777216);
            guiGraphics.fill(listX + listWidth, listY - 2, listX + listWidth + 1, listY + listHeight, -16777216);
            int scrollBoxX = listX + listWidth + 2;
            int scrollBoxWidth = 11;
            int scrollBoxY = listY - 1;
            int scrollBoxHeight = listHeight + 1;
            int yOffset = 22;
            int maxIndex = Math.min(this.networkScrollIndex + 3, this.knownNetworks.size());
            for (int i = this.networkScrollIndex; i < maxIndex; ++i) {
                NetworkInfo info = this.knownNetworks.get(i);
                boolean isSelected = this.selectedNetwork != null && this.selectedNetwork.equals(info);
                int textX = this.leftPos + this.textAdjust + 8;
                int textY = this.topPos + yOffset;
                int textWidth = this.font.width(info.networkName());
                Objects.requireNonNull(this.font);
                int textHeight = 9;
                if (isSelected) {
                    guiGraphics.fill(textX - 2, textY - 1, textX + textWidth + 2, textY + textHeight + 1, -16733441);
                }
                MutableComponent networkText = Component.literal((String)info.networkName()).withStyle(style -> style.withUnderlined(Boolean.valueOf(true)).withColor(isSelected ? 0xFFFFFF : 0));
                guiGraphics.drawString(this.font, (Component)networkText, textX, textY, 0x404040, false);
                Objects.requireNonNull(this.font);
                yOffset += 9 + 2;
            }
            if (this.knownNetworks.size() > 3) {
                guiGraphics.fill(scrollBoxX - 1, scrollBoxY - 1, scrollBoxX + scrollBoxWidth, scrollBoxY + scrollBoxHeight + 1, -3355444);
                guiGraphics.fill(scrollBoxX - 2, scrollBoxY - 2, scrollBoxX + scrollBoxWidth + 1, scrollBoxY - 1, -16777216);
                guiGraphics.fill(scrollBoxX - 2, scrollBoxY + scrollBoxHeight, scrollBoxX + scrollBoxWidth + 1, scrollBoxY + scrollBoxHeight + 1, -16777216);
                guiGraphics.fill(scrollBoxX - 2, scrollBoxY - 1, scrollBoxX - 1, scrollBoxY + scrollBoxHeight, -16777216);
                guiGraphics.fill(scrollBoxX + scrollBoxWidth, scrollBoxY - 1, scrollBoxX + scrollBoxWidth + 1, scrollBoxY + scrollBoxHeight, -16777216);
                int scrollBarX = listX + listWidth + 1;
                int scrollBarY = listY - 2;
                int scrollBarHeight = listHeight + 2;
                int totalNetworks = this.knownNetworks.size();
                int maxScroll = totalNetworks - 3;
                int thumbY = scrollBarY + (scrollBarHeight - 15) * this.networkScrollIndex / maxScroll;
                guiGraphics.blit(SCROLL_SPRITE, scrollBarX, thumbY, 168.0f, 0.0f, 12, 15, 12, 15);
            }
        }
        int x = this.leftPos + 10;
        int y = this.topPos + 30;
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderButtonTooltips(guiGraphics, mouseX, mouseY, this.leftPos, this.topPos);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        MousePositionManagerUtil.getLastKnownPosition();
        if (this.managerModes == ManagerModes.CREATE) {
            if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, this.leftPos + this.managerButtonX, this.topPos + this.managerButtonY, 0, 0, 17, 17)) {
                this.managerModes = ManagerModes.JOIN;
                this.init();
            } else if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, this.leftPos + this.confirmButtonX, this.topPos + this.confirmButtonY, 0, 0, 17, 17)) {
                Minecraft.getInstance().player.connection.send((CustomPacketPayload)new CreateNetworkPacketC2S(this.createNetworkNameEditBox.getValue(), this.createNetworkPasswordEditBox.getValue()));
                Minecraft.getInstance().player.closeContainer();
            }
        } else if (this.managerModes == ManagerModes.JOIN) {
            int thumbHeight;
            int thumbY;
            int listX = this.leftPos + this.textAdjust + 3;
            int listY = this.topPos + 22;
            int listWidth = 100;
            Objects.requireNonNull(this.font);
            int listHeight = (9 + 2) * 3;
            int scrollBarX = listX + listWidth + 1;
            int scrollBarY = listY - 2;
            int scrollBarHeight = listHeight + 2;
            int totalNetworks = this.knownNetworks.size();
            int maxScroll = totalNetworks - 3;
            if (totalNetworks > 3 && MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, scrollBarX, thumbY = scrollBarY + (scrollBarHeight - (thumbHeight = 15)) * this.networkScrollIndex / maxScroll, 0, 0, 12, thumbHeight)) {
                this.draggingScrollBar = true;
                this.dragOffsetY = (int)mouseY - thumbY;
                return true;
            }
            int yOffset = this.topPos + 22;
            int maxIndex = Math.min(this.networkScrollIndex + 3, this.knownNetworks.size());
            for (int i = this.networkScrollIndex; i < maxIndex; ++i) {
                int textY = yOffset;
                int textX = this.leftPos + this.textAdjust + 5;
                int textWidth = this.font.width(this.knownNetworks.get(i).networkName());
                Objects.requireNonNull(this.font);
                int textHeight = 9;
                if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, textX, textY, 0, 0, textWidth, textHeight)) {
                    this.selectedNetwork = this.knownNetworks.get(i);
                    return true;
                }
                yOffset += textHeight + 2;
            }
            if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, this.leftPos + this.confirmButtonX, this.topPos + this.confirmButtonY, 0, 0, 17, 17)) {
                if (this.selectedNetwork != null) {
                    Minecraft.getInstance().player.connection.send((CustomPacketPayload)new JoinNetworkPacketC2S(this.selectedNetwork.networkId(), this.joinNetworkPasswordEditBox.getValue()));
                    Minecraft.getInstance().player.closeContainer();
                } else {
                    Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"gui.swiss.no_network_selected"), true);
                }
            } else if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, this.leftPos + this.managerButtonX, this.topPos + this.managerButtonY, 0, 0, 17, 17)) {
                this.managerModes = ManagerModes.CREATE;
                this.init();
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScrollBar && this.managerModes == ManagerModes.JOIN) {
            Objects.requireNonNull(this.font);
            int listHeight = (9 + 2) * 3;
            int scrollBarY = this.topPos + 22;
            int scrollBarHeight = listHeight;
            int totalNetworks = this.knownNetworks.size();
            int maxScroll = totalNetworks - 3;
            int thumbHeight = 15;
            int trackHeight = scrollBarHeight - thumbHeight;
            int newThumbY = (int)mouseY - this.dragOffsetY;
            newThumbY = Math.max(scrollBarY, Math.min(scrollBarY + trackHeight, newThumbY));
            int relativeY = newThumbY - scrollBarY;
            this.networkScrollIndex = relativeY * maxScroll / trackHeight;
            this.networkScrollIndex = Math.max(0, Math.min(maxScroll, this.networkScrollIndex));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingScrollBar = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.managerModes == ManagerModes.JOIN) {
            int maxScroll = Math.max(0, this.knownNetworks.size() - 3);
            if (scrollY < 0.0 && this.networkScrollIndex < maxScroll) {
                ++this.networkScrollIndex;
            } else if (scrollY > 0.0 && this.networkScrollIndex > 0) {
                --this.networkScrollIndex;
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean isFocused;
        if (keyCode == 256) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        boolean bl = isFocused = this.createNetworkNameEditBox.isFocused() || this.createNetworkPasswordEditBox.isFocused() || this.joinNetworkPasswordEditBox.isFocused();
        if (isFocused && keyCode == Minecraft.getInstance().options.keyInventory.getKey().getValue()) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void renderButtonTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (this.managerModes == ManagerModes.CREATE) {
            if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, this.managerButtonX, this.managerButtonY, 17, 17)) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.swiss.create_settings"), mouseX, mouseY);
            } else if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, this.confirmButtonX, this.confirmButtonY, 17, 17)) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.swiss.confirm_create"), mouseX, mouseY);
            }
        }
        if (this.managerModes == ManagerModes.JOIN) {
            if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, this.managerButtonX, this.managerButtonY, 17, 17)) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.swiss.join_settings"), mouseX, mouseY);
            } else if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, this.confirmButtonX, this.confirmButtonY, 17, 17)) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.swiss.confirm_join"), mouseX, mouseY);
            }
        }
    }
}

