/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.screen.interfaces.exporter;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.mangorage.swiss.network.SyncFilterItemsPacketC2S;
import org.mangorage.swiss.screen.Buttons;
import org.mangorage.swiss.screen.interfaces.exporter.ExporterMenu;
import org.mangorage.swiss.storage.util.IUpdatable;
import org.mangorage.swiss.util.MousePositionManagerUtil;

public final class ExporterScreen
extends AbstractContainerScreen<ExporterMenu>
implements IUpdatable {
    private int scrollIndex = 0;
    private static final int ITEMS_PER_PAGE = 24;
    private static final int SCROLLBAR_WIDTH = 12;
    private static final int SCROLLBAR_HEIGHT = 54;
    private static final int SCROLLBAR_X_OFFSET = 154;
    private static final int SCROLLBAR_Y_OFFSET = 16;
    private boolean isDraggingScrollbar = false;
    private int dragOffsetY = 0;
    int filterY = 20;
    int upgradeY = 49;
    private List<ItemStack> filterItems = new ArrayList<ItemStack>();
    private List<ItemStack> upgradeItems = new ArrayList<ItemStack>();
    private ItemStack selectedFilter = ItemStack.EMPTY;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/import_export_gui.png");

    public ExporterScreen(ExporterMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.imageHeight = 165;
        this.imageWidth = 209;
        this.inventoryLabelX = 25;
        this.titleLabelX = 25;
        while (this.filterItems.size() < 9) {
            this.filterItems.add(ItemStack.EMPTY);
        }
        while (this.upgradeItems.size() < 9) {
            this.upgradeItems.add(ItemStack.EMPTY);
        }
    }

    @Override
    public void update() {
        while (this.filterItems.size() < 9) {
            this.filterItems.add(ItemStack.EMPTY);
        }
    }

    public void syncFilterItems() {
        HashMap<Integer, ItemStack> filterItemsMap = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < this.filterItems.size(); ++i) {
            ItemStack stack = this.filterItems.get(i);
            if (stack.isEmpty()) continue;
            filterItemsMap.put(i, stack);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncFilterItemsPacketC2S(filterItemsMap, ((ExporterMenu)this.menu).getBlockEntity().getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void onClose() {
        super.onClose();
        MousePositionManagerUtil.clear();
    }

    protected void init() {
        super.init();
        MousePositionManagerUtil.setLastKnownPosition();
        this.filterItems = ((ExporterMenu)this.getMenu()).blockEntity.getExportItems();
        while (this.filterItems.size() < 9) {
            this.filterItems.add(ItemStack.EMPTY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        Buttons.DEFAULT_INTERFACE.blit(guiGraphics, this.leftPos, this.topPos);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int y;
        int x;
        int i;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int startX = this.leftPos + 8;
        for (i = 0; i < this.filterItems.size(); ++i) {
            x = startX + i * 18 + 17;
            y = this.topPos + this.filterY;
            ItemStack filterStack = this.filterItems.get(i);
            guiGraphics.renderItem(filterStack, x, y);
            guiGraphics.renderItemDecorations(this.font, filterStack, x, y);
            if (!this.selectedFilter.isEmpty() && ItemStack.isSameItem((ItemStack)filterStack, (ItemStack)this.selectedFilter)) {
                guiGraphics.fill(x - 1, y - 1, x + 17, y + 17, -1426063361);
            }
            if (mouseX >= x && mouseX < x + 16 && mouseY >= y && mouseY < y + 16) {
                guiGraphics.renderTooltip(this.font, filterStack, mouseX, mouseY);
            }
            Buttons.DEFAULT_INTERFACE.renderButtonTooltips(guiGraphics, this.font, mouseX, mouseY, this.leftPos, this.topPos);
        }
        for (i = 0; i < this.upgradeItems.size(); ++i) {
            x = startX + i * 18 + 17;
            y = this.topPos + this.upgradeY;
            ItemStack upgradeStack = this.upgradeItems.get(i);
            guiGraphics.renderItem(upgradeStack, x, y);
            guiGraphics.renderItemDecorations(this.font, upgradeStack, x, y);
            if (mouseX < x || mouseX >= x + 16 || mouseY < y || mouseY >= y + 16) continue;
            guiGraphics.renderTooltip(this.font, upgradeStack, mouseX, mouseY);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int x;
        int i;
        MousePositionManagerUtil.getLastKnownPosition();
        int startX = this.leftPos + 25;
        ItemStack heldStack = ((ExporterMenu)this.getMenu()).getCarried();
        for (i = 0; i < this.filterItems.size(); ++i) {
            x = startX + i * 18;
            if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 16)) || !(mouseY >= (double)(this.filterY + this.topPos)) || !(mouseY < (double)(this.filterY + 16 + this.topPos))) continue;
            if (!heldStack.isEmpty()) {
                ItemStack newFilter = heldStack.copy();
                newFilter.setCount(1);
                this.filterItems.set(i, newFilter);
                this.selectedFilter = newFilter;
            } else {
                this.filterItems.set(i, ItemStack.EMPTY);
                this.selectedFilter = ItemStack.EMPTY;
            }
            this.syncFilterItems();
            return true;
        }
        for (i = 0; i < this.upgradeItems.size(); ++i) {
            x = startX + i * 18;
            if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 16)) || !(mouseY >= (double)(this.upgradeY + this.topPos)) || !(mouseY < (double)(this.upgradeY + 16 + this.topPos))) continue;
            this.onUpgradeClicked(i);
            return true;
        }
        Buttons.DEFAULT_INTERFACE.mouseClicked((int)mouseX, (int)mouseY, button, this.leftPos, this.topPos);
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void onUpgradeClicked(int index) {
        System.out.println("Upgrade clicked: " + index);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

