/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.screen.interfaces.exporter;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.mangorage.swiss.StorageNetworkManager;
import org.mangorage.swiss.registry.SWISSBlocks;
import org.mangorage.swiss.screen.MSMenuTypes;
import org.mangorage.swiss.screen.interfaces.config_block.ConfigureBlockNetworkMenu;
import org.mangorage.swiss.screen.misc.setting.SettingsMenu;
import org.mangorage.swiss.screen.util.Interact;
import org.mangorage.swiss.storage.network.ISyncableNetworkHandler;
import org.mangorage.swiss.storage.network.NetworkInfo;
import org.mangorage.swiss.storage.util.IPacketRequest;
import org.mangorage.swiss.world.block.entity.item.interfaces.ItemExporterBlockEntity;

public final class ExporterMenu
extends AbstractContainerMenu
implements ISyncableNetworkHandler,
IPacketRequest,
Interact {
    public ItemExporterBlockEntity blockEntity;
    List<ItemStack> itemStacks = List.of();
    public Level level;
    public Player player;
    private BlockPos blockPos;
    public List<ItemStack> filterItems = new ArrayList<ItemStack>();
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 3;

    public ExporterMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos());
    }

    public ExporterMenu(int containerID, Inventory inventory, BlockPos blockPos) {
        super((MenuType)MSMenuTypes.EXPORTER_MENU.get(), containerID);
        this.player = inventory.player;
        this.blockPos = blockPos;
        this.level = inventory.player.level();
        this.blockEntity = (ItemExporterBlockEntity)this.level.getBlockEntity(blockPos);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
    }

    public ItemExporterBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public void sendAllDataToRemote() {
        super.sendAllDataToRemote();
        if (!this.level.isClientSide()) {
            // empty if block
        }
    }

    @Override
    public void clicked(ItemStack itemStack, CompoundTag extraData, ClickType clickType, int button) {
        if (button == 1) {
            this.player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new SettingsMenu(windowId, playerInventory, this.blockPos), (Component)Component.translatable((String)"gui.swiss.configure_block_network")), buf -> buf.writeBlockPos(this.blockPos));
        } else if (button == 2) {
            this.player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new ConfigureBlockNetworkMenu(windowId, playerInventory, this.blockPos), (Component)Component.translatable((String)"gui.swiss.configure_block_network")), buf -> {
                buf.writeBlockPos(this.blockPos);
                NetworkInfo.LIST_STREAM_CODEC.encode(buf, StorageNetworkManager.getInstance().getNetworkInfo((ServerPlayer)this.player));
            });
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return ExporterMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.blockPos), (Player)player, (Block)((Block)SWISSBlocks.EXPORTER_ITEM_INTERFACE_BLOCK.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18 + 17, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18 + 17, 142));
        }
    }

    @Override
    public void sync(Object object) {
        if (object instanceof ItemList) {
            ItemList itemList = (ItemList)object;
            try {
                List<ItemStack> list;
                List<ItemStack> stacks = list = itemList.stacks();
                this.itemStacks = stacks;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    @Override
    public void requested(ServerPlayer player) {
    }

    public record ItemList(List<ItemStack> stacks) {
    }
}

