/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.screen.interfaces.config_block;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.mangorage.swiss.network.MenuInteractPacketC2S;
import org.mangorage.swiss.screen.interfaces.config_block.ConfigureBlockNetworkMenu;
import org.mangorage.swiss.storage.network.NetworkInfo;
import org.mangorage.swiss.storage.util.IUpdatable;
import org.mangorage.swiss.util.MousePositionManagerUtil;
import org.mangorage.swiss.util.MouseUtil;

public class ConfigureBlockNetworkScreen
extends AbstractContainerScreen<ConfigureBlockNetworkMenu>
implements IUpdatable {
    private int scrollOffset = 0;
    private final int maxVisibleLines = 3;
    private final int lineHeight = 12;
    public int textAdjust = 8;
    private EditBox joinNetworkPasswordEditBox;
    private int networkScrollIndex = 0;
    private final int VISIBLE_NETWORKS = 3;
    private int confirmButtonX = 155;
    private int confirmButtonY = 55;
    private NetworkInfo selectedNetwork;
    private List<NetworkInfo> knownNetworks = List.of();
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/settings_gui.png");
    private static final ResourceLocation BUTTON_CONFIRM = ResourceLocation.fromNamespaceAndPath((String)"swiss", (String)"textures/gui/button_confirm.png");

    public ConfigureBlockNetworkScreen(ConfigureBlockNetworkMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.imageHeight = 165;
        this.imageWidth = 175;
        this.knownNetworks = menu.networkInfo;
    }

    @Override
    public void update() {
    }

    public void onClose() {
        super.onClose();
        MousePositionManagerUtil.clear();
    }

    protected void init() {
        super.init();
        MousePositionManagerUtil.setLastKnownPosition();
        this.joinNetworkPasswordEditBox = new EditBox(this.font, this.leftPos + this.textAdjust, this.topPos + 56, 80, 14, (Component)Component.translatable((String)"gui.swiss.join_password"));
        this.addRenderableWidget((GuiEventListener)this.joinNetworkPasswordEditBox);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.blit(BUTTON_CONFIRM, this.leftPos + this.confirmButtonX, this.topPos + this.confirmButtonY, 0.0f, 0.0f, 17, 17, 17, 17);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int x = this.leftPos + 10;
        int y = this.topPos + 30;
        this.joinNetworkPasswordEditBox.render(guiGraphics, mouseX, mouseY, partialTicks);
        int yOffset = 22;
        int maxIndex = Math.min(this.networkScrollIndex + 3, this.knownNetworks.size());
        for (int i = this.networkScrollIndex; i < maxIndex; ++i) {
            NetworkInfo info = this.knownNetworks.get(i);
            boolean isSelected = this.selectedNetwork != null && this.selectedNetwork.equals(info);
            MutableComponent networkText = Component.literal((String)info.networkName()).withStyle(style -> style.withUnderlined(Boolean.valueOf(true)).withColor(isSelected ? 43775 : 0));
            guiGraphics.drawString(this.font, (Component)networkText, this.leftPos + this.textAdjust + 5, this.topPos + yOffset, 0x404040, false);
            Objects.requireNonNull(this.font);
            yOffset += 9 + 2;
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        MousePositionManagerUtil.getLastKnownPosition();
        int yOffset = this.topPos + 22;
        int maxIndex = Math.min(this.networkScrollIndex + 3, this.knownNetworks.size());
        for (int i = this.networkScrollIndex; i < maxIndex; ++i) {
            int textY = yOffset;
            int textX = this.leftPos + this.textAdjust + 5;
            int textWidth = this.font.width(this.knownNetworks.get(i).networkName());
            Objects.requireNonNull(this.font);
            int textHeight = 9;
            if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, textX, textY, 0, 0, textWidth, textHeight)) {
                this.selectedNetwork = this.knownNetworks.get(i);
                return true;
            }
            yOffset += textHeight + 2;
        }
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, this.leftPos + this.confirmButtonX, this.topPos + this.confirmButtonY, 0, 0, 17, 17)) {
            if (this.selectedNetwork != null) {
                CompoundTag data = new CompoundTag();
                data.putUUID("id", this.selectedNetwork.networkId());
                Minecraft.getInstance().player.connection.send((CustomPacketPayload)new MenuInteractPacketC2S(data, 1));
                Minecraft.getInstance().player.closeContainer();
            } else {
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"gui.swiss.no_network_selected"), true);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int maxScroll = Math.max(0, this.knownNetworks.size() - 3);
        if (scrollY < 0.0 && this.networkScrollIndex < maxScroll) {
            ++this.networkScrollIndex;
        } else if (scrollY > 0.0 && this.networkScrollIndex > 0) {
            --this.networkScrollIndex;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void renderButtonTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, this.confirmButtonX, this.confirmButtonY, 17, 17)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.swiss.confirm_join"), mouseX, mouseY);
        }
    }
}

