/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.network;

import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import org.mangorage.swiss.SWISS;
import org.mangorage.swiss.screen.panels.craftingpanel.CraftingPanelMenu;
import org.mangorage.swiss.storage.network.Network;
import org.mangorage.swiss.storage.util.ItemHandlerLookup;

public record SyncRecipePacketC2S(ResourceLocation recipeID, boolean maxTransfer) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncRecipePacketC2S> TYPE = new CustomPacketPayload.Type(SWISS.modRL("sync_recipe_c2s"));
    public static final IPayloadHandler<SyncRecipePacketC2S> HANDLER = (pkt, ctx) -> {
        ServerPlayer player = (ServerPlayer)ctx.player();
        AbstractContainerMenu patt0$temp = player.containerMenu;
        if (patt0$temp instanceof CraftingPanelMenu) {
            Recipe patt1$temp;
            CraftingPanelMenu menu = (CraftingPanelMenu)patt0$temp;
            MinecraftServer server = player.server;
            Optional optional = server.getRecipeManager().byKey(pkt.recipeID());
            if (optional.isPresent() && (patt1$temp = ((RecipeHolder)optional.get()).value()) instanceof CraftingRecipe) {
                int slot;
                CraftingRecipe recipe = (CraftingRecipe)patt1$temp;
                if (menu.getNetworkHolder() == null || menu.getNetworkHolder().getNetwork() == null) {
                    return;
                }
                Network network = menu.getNetworkHolder().getNetwork();
                ItemHandlerLookup extractor = ItemHandlerLookup.getLookupForExtract(network);
                ItemHandlerLookup inserter = ItemHandlerLookup.getLookupForInsert(network);
                for (int i = 0; i < menu.craftMatrix.getContainerSize(); ++i) {
                    ItemStack stackInSlot = menu.craftMatrix.getItem(i);
                    if (stackInSlot.isEmpty()) continue;
                    ItemStack leftover = inserter.insertIntoHandlers(stackInSlot);
                    if (!leftover.isEmpty()) {
                        return;
                    }
                    menu.craftMatrix.setItem(i, ItemStack.EMPTY);
                }
                NonNullList ingredients = recipe.getIngredients();
                ItemStack[] extractedStacks = new ItemStack[ingredients.size()];
                boolean canExtractAll = true;
                for (slot = 0; slot < ingredients.size(); ++slot) {
                    Ingredient ingredient = (Ingredient)ingredients.get(slot);
                    if (ingredient.isEmpty()) {
                        extractedStacks[slot] = ItemStack.EMPTY;
                        continue;
                    }
                    ItemStack extracted = ItemStack.EMPTY;
                    for (ItemStack possibleMatch : ingredient.getItems()) {
                        int count = pkt.maxTransfer() ? Math.min(possibleMatch.getMaxStackSize(), menu.craftMatrix.getMaxStackSize()) : 1;
                        extracted = extractor.findAny(possibleMatch.getItem(), count);
                        if (!extracted.isEmpty()) break;
                    }
                    if (extracted.isEmpty()) {
                        canExtractAll = false;
                        break;
                    }
                    extractedStacks[slot] = extracted;
                }
                if (!canExtractAll) {
                    return;
                }
                for (slot = 0; slot < extractedStacks.length; ++slot) {
                    menu.craftMatrix.setItem(slot, extractedStacks[slot]);
                }
                menu.slotsChanged((Container)menu.craftMatrix);
            }
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncRecipePacketC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, SyncRecipePacketC2S::recipeID, (StreamCodec)ByteBufCodecs.BOOL, SyncRecipePacketC2S::maxTransfer, SyncRecipePacketC2S::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

