/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.network;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import org.mangorage.swiss.SWISS;
import org.mangorage.swiss.world.block.entity.base.BaseStorageBlockEntity;
import org.mangorage.swiss.world.block.entity.item.interfaces.ItemExporterBlockEntity;
import org.mangorage.swiss.world.block.entity.item.interfaces.ItemImporterBlockEntity;

public record SyncFilterItemsPacketC2S(Map<Integer, ItemStack> stackBySlot, BlockPos entityPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncFilterItemsPacketC2S> TYPE = new CustomPacketPayload.Type(SWISS.modRL("sync_filter_items_c2s"));
    public static final IPayloadHandler<SyncFilterItemsPacketC2S> HANDLER = (pkt, ctx) -> {
        int maxSlot;
        Map<Integer, ItemStack> newItems;
        BaseStorageBlockEntity itemExporter;
        Player player = ctx.player();
        BlockPos pos = pkt.entityPos();
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ItemExporterBlockEntity) {
            itemExporter = (ItemExporterBlockEntity)blockEntity;
            itemExporter.exportItems.clear();
            newItems = pkt.stackBySlot();
            maxSlot = newItems.keySet().stream().max(Integer::compareTo).orElse(-1);
            while (itemExporter.exportItems.size() <= maxSlot) {
                itemExporter.exportItems.add(ItemStack.EMPTY);
            }
            newItems.forEach(itemExporter.exportItems::set);
            itemExporter.setChanged();
        }
        if (blockEntity instanceof ItemImporterBlockEntity) {
            itemExporter = (ItemImporterBlockEntity)blockEntity;
            ((ItemImporterBlockEntity)itemExporter).importItems.clear();
            newItems = pkt.stackBySlot();
            maxSlot = newItems.keySet().stream().max(Integer::compareTo).orElse(-1);
            while (((ItemImporterBlockEntity)itemExporter).importItems.size() <= maxSlot) {
                ((ItemImporterBlockEntity)itemExporter).importItems.add(ItemStack.EMPTY);
            }
            newItems.forEach(((ItemImporterBlockEntity)itemExporter).importItems::set);
            itemExporter.setChanged();
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncFilterItemsPacketC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.INT, (StreamCodec)ItemStack.STREAM_CODEC), SyncFilterItemsPacketC2S::stackBySlot, (StreamCodec)BlockPos.STREAM_CODEC, SyncFilterItemsPacketC2S::entityPos, SyncFilterItemsPacketC2S::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

