/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.integration;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.library.transfer.RecipeTransferErrorTooltip;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mangorage.swiss.screen.MSMenuTypes;
import org.mangorage.swiss.screen.panels.craftingpanel.CraftingPanelMenu;
import org.mangorage.swiss.storage.util.ItemHandlerLookup;

public class CraftingPanelRecipeTransferInfo
implements IRecipeTransferInfo<CraftingPanelMenu, RecipeHolder<CraftingRecipe>> {
    @NotNull
    public Class<? extends CraftingPanelMenu> getContainerClass() {
        return CraftingPanelMenu.class;
    }

    @NotNull
    public Optional<MenuType<CraftingPanelMenu>> getMenuType() {
        return Optional.of((MenuType)MSMenuTypes.CRAFTING_MENU.get());
    }

    @NotNull
    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @NotNull
    public List<Slot> getRecipeSlots(CraftingPanelMenu menu, RecipeHolder<CraftingRecipe> recipe) {
        return menu.slots.subList(37, 46);
    }

    @NotNull
    public List<Slot> getInventorySlots(CraftingPanelMenu menu, RecipeHolder<CraftingRecipe> recipe) {
        return menu.slots.subList(0, 35);
    }

    @Nullable
    public IRecipeTransferError getHandlingError(CraftingPanelMenu container, RecipeHolder<CraftingRecipe> recipeHolder) {
        CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
        NonNullList ingredients = recipe.getIngredients();
        if (container.getNetworkHolder() == null || container.getNetworkHolder().getNetwork() == null) {
            return new RecipeTransferErrorTooltip((Component)Component.literal((String)"Network unavailable"));
        }
        ItemHandlerLookup extract = ItemHandlerLookup.getLookupForExtract(container.getNetworkHolder().getNetwork());
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            boolean foundAny = false;
            for (ItemStack stack : ingredient.getItems()) {
                if (extract.findAny(stack.getItem(), 1).isEmpty()) continue;
                foundAny = true;
                break;
            }
            if (foundAny) continue;
            return new RecipeTransferErrorTooltip((Component)Component.literal((String)"Missing required ingredients in network"));
        }
        return null;
    }

    public boolean canHandle(@NotNull CraftingPanelMenu menu, RecipeHolder<CraftingRecipe> recipe) {
        return true;
    }
}

