/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.data;

import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.mangorage.swiss.registry.SWISSBlocks;
import org.mangorage.swiss.registry.SWISSItems;

public final class SWISSLangProvider
extends LanguageProvider {
    public SWISSLangProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "swiss", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.swiss", "SWISS");
        this.addBlock((Supplier)SWISSBlocks.EXPORTER_ITEM_INTERFACE_BLOCK, "Item Exporter Interface");
        this.addBlock((Supplier)SWISSBlocks.IMPORTER_ITEM_INTERFACE_BLOCK, "Item Importer Interface");
        this.addBlock((Supplier)SWISSBlocks.STORAGE_ITEM_INTERFACE_BLOCK, "Item Storage Interface");
        this.addBlock((Supplier)SWISSBlocks.STORAGE_ITEM_PANEL_BLOCK, "Item Storage Panel");
        this.addBlock((Supplier)SWISSBlocks.CRAFTING_ITEM_PANEL_BLOCK, "Crafting Storage Panel");
        this.addItem((Supplier)SWISSItems.SWISS_CHEESE, "Swiss Cheese");
        this.addGUITranslation("settings_menu", "Open Settings Menu");
        this.addGUITranslation("settings_menu_title", "Settings");
        this.addGUITranslation("network_settings", "Open Network Settings");
        this.addGUITranslation("create_join_network_settings", "Open Create/Join Network Settings");
        this.addGUITranslation("row_menu", "Click to change rows");
        this.addGUITranslation("network_menu_title", "Network Settings");
        this.addGUITranslation("manger_menu_title", "Manage Network");
        this.addGUITranslation("name", "Network Names");
        this.addGUITranslation("set_name", "Set Network Name");
        this.addGUITranslation("password", "Network Password");
        this.addGUITranslation("set_password", "Set Network Password");
        this.addGUITranslation("known_networks", "Known Networks");
        this.addGUITranslation("create_network", "Create Network");
        this.addGUITranslation("join_network", "Join Network");
        this.addGUITranslation("create_settings", "Join Network?");
        this.addGUITranslation("join_settings", "Create Network?");
        this.addGUITranslation("confirm_create", "Create New Network");
        this.addGUITranslation("confirm_join", "Join Selected Network");
        this.addGUITranslation("configure_block_network", "Configure Block Network");
    }

    private void addItemTranslation(String name, String translation) {
        this.add("item.swiss." + name, translation);
    }

    private void addBlockTranslation(String name, String translation) {
        this.add("block.swiss." + name, translation);
    }

    private void addChatTranslation(String name, String translation) {
        this.add("chat.swiss." + name, translation);
    }

    private void addGUITranslation(String name, String translation) {
        this.add("gui.swiss." + name, translation);
    }

    private void addTooltipTranslation(String name, String translation) {
        this.add("tooltips.swiss." + name, translation);
    }

    public static String capitalizeFirstLetterOfEachWord(String input) {
        String[] words = input.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase()).append(" ");
        }
        return result.toString().trim();
    }
}

