/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss.data;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.mangorage.swiss.data.SWISSBlockStatesProvider;
import org.mangorage.swiss.data.SWISSBlockTags;
import org.mangorage.swiss.data.SWISSItemModelProvider;
import org.mangorage.swiss.data.SWISSItemTags;
import org.mangorage.swiss.data.SWISSLangProvider;
import org.mangorage.swiss.data.SWISSLootTableProvider;
import org.mangorage.swiss.data.SWISSRecipeProvider;

@EventBusSubscriber(modid="swiss")
public final class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new SWISSRecipeProvider(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(SWISSLootTableProvider::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        SWISSBlockTags blockTags = new SWISSBlockTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        SWISSItemTags itemTags = new SWISSItemTags(packOutput, lookupProvider, blockTags, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        generator.addProvider(event.includeClient(), (DataProvider)new SWISSItemModelProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new SWISSBlockStatesProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new SWISSLangProvider(packOutput, event.getExistingFileHelper()));
    }
}

