/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.swiss;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.mangorage.swiss.storage.network.Network;
import org.mangorage.swiss.storage.network.NetworkInfo;
import org.mangorage.swiss.storage.network.Permission;
import org.mangorage.swiss.storage.network.UnknownNetwork;
import org.mangorage.swiss.storage.network.User;

public final class StorageNetworkManager
extends SavedData {
    private static StorageNetworkManager instance = null;
    private final Map<UUID, Network> networkMap = new HashMap<UUID, Network>();

    static SavedData.Factory<StorageNetworkManager> factory() {
        return new SavedData.Factory(StorageNetworkManager::new, StorageNetworkManager::load);
    }

    static StorageNetworkManager load(CompoundTag tag, HolderLookup.Provider registries) {
        StorageNetworkManager networkManager = new StorageNetworkManager();
        networkManager.loadInternal(tag, registries);
        return networkManager;
    }

    public static StorageNetworkManager getInstance() {
        return instance;
    }

    static void start(MinecraftServer server) {
        instance = (StorageNetworkManager)server.getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(StorageNetworkManager.factory(), "swiss-network-data");
        instance.setDirty(false);
    }

    static void stop() {
        instance = null;
    }

    StorageNetworkManager() {
    }

    public Network getNetwork(MinecraftServer server, UUID id) {
        if (server == null) {
            throw new IllegalStateException("Cant create network, need MinecraftServer Instance...");
        }
        return this.networkMap.getOrDefault(id, UnknownNetwork.INSTANCE);
    }

    public void createNetwork(String name, String password, ServerPlayer player) {
        for (Network value : this.networkMap.values()) {
            if (!value.getNetworkName().equals(name)) continue;
            player.sendSystemMessage((Component)Component.literal((String)"Unable to create network, network name already exists!"));
            break;
        }
        Network network = new Network(UUID.randomUUID());
        network.setNetworkName(name);
        User user = new User(player.getUUID());
        user.addPermission(Permission.OWNER);
        network.registerUser(user);
        this.networkMap.put(network.getId(), network);
        player.sendSystemMessage((Component)Component.literal((String)"Created Network!"));
    }

    public void joinNetwork(ServerPlayer player, UUID uuid, String password) {
        Network network = this.getNetwork(player.getServer(), uuid);
        if (network == null) {
            player.sendSystemMessage((Component)Component.literal((String)"Network does not exist!"));
            return;
        }
        if (network.hasUser(player.getUUID())) {
            player.sendSystemMessage((Component)Component.literal((String)"Already in network!"));
            return;
        }
        User user = new User(uuid);
        user.addPermission(Permission.ADMIN);
        network.registerUser(user);
        player.sendSystemMessage((Component)Component.literal((String)"Joined Network!"));
    }

    public List<NetworkInfo> getNetworkInfo(ServerPlayer player) {
        return this.networkMap.values().stream().map(network -> network.getInfo(player)).toList();
    }

    public void save(File file, HolderLookup.Provider registries) {
        this.checkDirty();
        super.save(file, registries);
    }

    void checkDirty() {
        for (Network network : this.networkMap.values()) {
            if (!network.isDirty()) continue;
            this.setDirty(true);
            break;
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag data = new CompoundTag();
        ListTag networksTag = new ListTag();
        this.networkMap.forEach((id, network) -> {
            CompoundTag networkTag = new CompoundTag();
            networkTag.putUUID("id", id);
            networksTag.add((Object)network.save(networkTag, registries));
        });
        data.put("networks", (Tag)networksTag);
        return data;
    }

    void loadInternal(CompoundTag data, HolderLookup.Provider registries) {
        ListTag networkTags = data.getList("networks", 10);
        for (int id = 0; id < networkTags.size(); ++id) {
            CompoundTag networkTag = networkTags.getCompound(id);
            Network network = new Network(networkTag.getUUID("id"));
            network.load(networkTag, registries);
            this.networkMap.put(network.getId(), network);
        }
    }
}

