/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf.fluid;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.zeith.hammerlib.util.mcf.fluid.FluidHelper;
import org.zeith.hammerlib.util.mcf.fluid.FluidIngredientStack;

public record FluidIngredient(CompareMode mode, List<FluidStack> asFluidStack, List<TagKey<Fluid>> asTags) implements Predicate<FluidStack>
{
    public static final MapCodec<FluidIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("mode").xmap(CompareMode::valueOf, Enum::name).forGetter(FluidIngredient::mode), (App)FluidStack.CODEC.listOf().fieldOf("fluids").forGetter(FluidIngredient::asFluidStack), (App)TagKey.codec((ResourceKey)BuiltInRegistries.FLUID.key()).listOf().fieldOf("tags").forGetter(FluidIngredient::asTags)).apply((Applicative)instance, FluidIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidIngredient> STREAM_CODEC = StreamCodec.of((buf, ing) -> ing.toNetwork((RegistryFriendlyByteBuf)buf), FluidIngredient::fromNetwork);
    public static FluidIngredient EMPTY = new FluidIngredient(CompareMode.VALUES, List.of(), List.of());

    public FluidIngredient(CompareMode mode, List<FluidStack> asFluidStack, List<TagKey<Fluid>> asTags) {
        this.mode = mode;
        this.asFluidStack = asFluidStack.stream().map(fs -> FluidHelper.withAmount(fs, 1)).toList();
        this.asTags = asTags;
    }

    public static FluidIngredient ofTags(List<TagKey<Fluid>> tags) {
        return new FluidIngredient(CompareMode.TAGS, List.of(), tags).resolve();
    }

    public static FluidIngredient ofFluids(List<FluidStack> fluids) {
        return new FluidIngredient(CompareMode.VALUES, fluids, List.of()).resolve();
    }

    public static FluidIngredient join(FluidIngredient ... ingredients) {
        ArrayList<FluidStack> asFluidStack = new ArrayList<FluidStack>();
        ArrayList<TagKey<Fluid>> asTags = new ArrayList<TagKey<Fluid>>();
        for (FluidIngredient ingredient : ingredients) {
            asTags.addAll(ingredient.asTags);
            asFluidStack.addAll(ingredient.asFluidStack);
        }
        if (asFluidStack.isEmpty()) {
            if (asTags.isEmpty()) {
                return EMPTY;
            }
            return FluidIngredient.ofTags(asTags);
        }
        if (asTags.isEmpty()) {
            return FluidIngredient.ofFluids(asFluidStack);
        }
        return new FluidIngredient(CompareMode.BOTH, asFluidStack, asTags);
    }

    FluidIngredient resolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.asFluidStack.isEmpty() && this.asTags().isEmpty();
    }

    public FluidIngredientStack stack(int amount) {
        return new FluidIngredientStack(this, amount);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(FluidStack fluidStack) {
        boolean bl;
        if (this.isEmpty()) {
            return fluidStack.isEmpty();
        }
        switch (this.mode.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 2: {
                if (this.asFluidStack.stream().anyMatch(fs -> FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)fs))) return true;
                if (!this.asTags.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getOrCreateTag(arg_0)).flatMap(HolderSet.ListBacked::stream).filter(Holder::isBound).map(Holder::value).anyMatch(fluidStack.getFluid()::equals)) return false;
                return true;
            }
            case 1: {
                bl = this.asFluidStack.stream().anyMatch(fs -> FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)fs));
                return bl;
            }
            case 0: {
                bl = this.asTags.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getOrCreateTag(arg_0)).flatMap(HolderSet.ListBacked::stream).filter(Holder::isBound).map(Holder::value).anyMatch(fluidStack.getFluid()::equals);
            }
        }
        return bl;
    }

    public FluidStack[] getValues() {
        return this.getValues(1);
    }

    public FluidStack[] getValues(int amount) {
        return switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> (FluidStack[])Stream.concat(this.asTags.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getOrCreateTag(arg_0)).flatMap(tag -> tag.stream().map(f -> new FluidStack(f, amount))), this.asFluidStack.stream().map(fs -> FluidHelper.withAmount(fs, amount))).toArray(FluidStack[]::new);
            case 0 -> (FluidStack[])this.asTags.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getOrCreateTag(arg_0)).flatMap(tag -> tag.stream().map(f -> new FluidStack(f, amount))).toArray(FluidStack[]::new);
            case 1 -> (FluidStack[])this.asFluidStack.stream().map(fs -> FluidHelper.withAmount(fs, amount)).toArray(FluidStack[]::new);
        };
    }

    public static FluidIngredient fromNetwork(RegistryFriendlyByteBuf buf) {
        CompareMode mode = (CompareMode)buf.readEnum(CompareMode.class);
        int cap = buf.readVarInt();
        ArrayList stacks = Lists.newArrayListWithCapacity((int)cap);
        for (int i = 0; i < cap; ++i) {
            stacks.add((FluidStack)FluidStack.STREAM_CODEC.decode((Object)buf));
        }
        cap = buf.readVarInt();
        ArrayList tags = Lists.newArrayListWithCapacity((int)cap);
        for (int i = 0; i < cap; ++i) {
            tags.add(TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)buf.readResourceLocation()));
        }
        return new FluidIngredient(mode, stacks, tags);
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.mode());
    }

    public static enum CompareMode {
        TAGS,
        VALUES,
        BOTH;

    }
}

