/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class DirectStorage<T>
implements Consumer<T>,
Supplier<T> {
    final Consumer<T> set;
    final Supplier<T> get;

    public DirectStorage(Consumer<T> set, Supplier<T> get) {
        this.set = set;
        this.get = get;
    }

    public void set(T val) {
        if (this.set != null) {
            this.set.accept(val);
        }
    }

    @Override
    public T get() {
        return this.get.get();
    }

    public T apply(UnaryOperator<T> operator) {
        Object v = operator.apply(this.get());
        this.set(v);
        return (T)v;
    }

    public static <T> DirectStorage<T> delegate(Supplier<DirectStorage<T>> to) {
        return DirectStorage.create(v -> ((DirectStorage)to.get()).set(v), () -> ((DirectStorage)to.get()).get());
    }

    public static <T> DirectStorage<T> create(Consumer<T> set, Supplier<T> get) {
        return new DirectStorage<T>(set, get);
    }

    public static <T> DirectStorage<T> readonly(Supplier<T> get) {
        return new DirectStorage<T>(null, get);
    }

    public static <T> DirectStorage<T> constant(T var) {
        return new DirectStorage<Object>(null, () -> var);
    }

    public static <T> DirectStorage<T> allocate() {
        AtomicReference ref = new AtomicReference();
        return DirectStorage.create(ref::set, ref::get);
    }

    public static <T> DirectStorage<T> allocate(T intitial) {
        AtomicReference<T> ref = new AtomicReference<T>(intitial);
        return DirectStorage.create(ref::set, ref::get);
    }

    public String toString() {
        return "DirectStorage{" + String.valueOf(this.get()) + "}";
    }

    @Override
    public void accept(T t) {
        this.set(t);
    }
}

