/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.zeith.hammerlib.util.java.StreamHelper;

public class Codec<T> {
    final Class<T> type;
    final List<Decoder<?, ?>> intermidiateDecoders = new ArrayList();
    final List<Decoder<?, T>> decoders = new ArrayList();

    public Codec(Class<T> type) {
        this.type = type;
        this.registerDecoder(Codec.decoder(type, Function.identity()));
    }

    public Codec<T> registerIntermediateDecoder(Decoder<?, T> decoder) {
        this.intermidiateDecoders.add(decoder);
        return this;
    }

    public Codec<T> registerDecoder(Decoder<?, T> decoder) {
        this.decoders.add(decoder);
        return this;
    }

    public Optional<T> decode(Object in) {
        boolean decoded;
        do {
            decoded = false;
            for (Decoder<?, ?> id : this.intermidiateDecoders) {
                if (!id.canDecode(in)) continue;
                in = id.decode(in);
                decoded = true;
            }
        } while (decoded);
        return this.decoders.stream().map(StreamHelper.inject(in)).filter(StreamHelper.filter(Decoder::canDecode)).map(StreamHelper.transform(Decoder::decode)).findFirst();
    }

    public static <I, O> Decoder<I, O> decoder(Class<I> type, Function<I, O> handle) {
        return new Decoder<I, O>(type, handle);
    }

    public static class Decoder<S, T> {
        final Class<S> handleType;
        final Predicate<S> decodable;
        final Function<S, T> decode;

        public Decoder(Class<S> handleType, Predicate<S> decodable, Function<S, T> decode) {
            this.handleType = handleType;
            this.decodable = decodable;
            this.decode = decode;
        }

        public Decoder(Class<S> handleType, Function<S, T> decode) {
            this.handleType = handleType;
            this.decodable = null;
            this.decode = decode;
        }

        public boolean canDecode(Object in) {
            return this.handleType.isAssignableFrom(in.getClass()) && (this.decodable == null || this.decodable.test(this.handleType.cast(in)));
        }

        public T decode(Object in) {
            return this.decode.apply(this.handleType.cast(in));
        }
    }
}

