/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.charging.impl;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.zeith.hammerlib.util.charging.IChargeHandler;
import org.zeith.hammerlib.util.charging.fe.FECharge;

@IChargeHandler.ChargeHandler(value=FECharge.class)
public class FEChargeHandler
implements IChargeHandler<FECharge> {
    @Override
    public String getId() {
        return "FE";
    }

    @Override
    public boolean canCharge(ItemStack stack, FECharge charge) {
        IEnergyStorage c = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (c == null) {
            return false;
        }
        return c.receiveEnergy(charge.FE, true) > 0;
    }

    @Override
    public FECharge charge(AtomicReference<ItemStack> stack, FECharge charge, IChargeHandler.ChargeAction action) {
        IEnergyStorage cap = (IEnergyStorage)stack.get().getCapability(Capabilities.EnergyStorage.ITEM);
        if (cap == null) {
            return charge;
        }
        return charge.discharge(cap.receiveEnergy(charge.FE, action.simulate()));
    }
}

