/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLLoader;
import org.zeith.hammerlib.util.JSONVisitor;
import org.zeith.hammerlib.util.java.net.HttpRequest;
import org.zeith.hammerlib.util.mcf.ModHelper;
import org.zeith.hammerlib.util.shaded.json.JSONTokener;

public class ZeithLinkRepository {
    private static final String DEFAULT_JSON = "{\n  \"discord\": {\n    \"dev\": {\n      \"card\": \"https://ds.zeith.org/cards/dev.png\",\n      \"invite\": \"https://ds.zeith.org/dev\"\n    }\n  },\n  \"mods\": {\n    \"improvableskills\": {\n      \"news\": \"https://assets.zeith.org/txt/is3-news.txt\"\n    }\n  }\n}\n";

    public static void initialize() {
    }

    public static String getLink(PredefinedLink link) {
        return Storage.LINKS.get(link.key());
    }

    public static Optional<String> findLink(String key) {
        return Optional.ofNullable(Storage.LINKS.get(key));
    }

    public static Optional<String> findModLink(ResourceLocation path) {
        return ZeithLinkRepository.findLink("mods/" + path.getNamespace() + "/" + path.getPath());
    }

    private static interface Storage {
        public static final Map<String, String> LINKS = new HashMap<String, String>(){
            {
                List<String> SOURCES = List.of("https://pastebin.com/raw/Wtfb9h01", "https://gist.githubusercontent.com/Zeitheron/78b4f4745cbf14b3d5974ee7ef437249/raw/link_repository.json", "https://mods.zeith.org/static/link_repository.json");
                Consumer<String> loader = json -> {
                    for (Map.Entry<String, Object> e : JSONVisitor.expand(new JSONTokener((String)json).nextValue(), "/", false).entrySet()) {
                        super.put(e.getKey(), Objects.toString(e.getValue()));
                    }
                };
                try {
                    loader.accept(ZeithLinkRepository.DEFAULT_JSON);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CompletableFuture.runAsync(() -> {
                    for (String src : SOURCES) {
                        try {
                            HttpRequest req = HttpRequest.get(src).acceptJson().userAgent("HammerLib " + ModHelper.getModVersion("hammerlib") + "; Minecraft " + FMLLoader.versionInfo().mcVersion()).connectTimeout(60000).readTimeout(60000);
                            try {
                                if (!req.ok()) continue;
                                loader.accept(req.body());
                                return;
                            }
                            finally {
                                if (req == null) continue;
                                req.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                });
            }

            @Override
            public String put(String key, String value) {
                return (String)this.get(key);
            }

            @Override
            public void putAll(Map<? extends String, ? extends String> m) {
            }

            @Override
            public String computeIfPresent(String key, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
                return (String)this.get(key);
            }

            @Override
            public String compute(String key, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
                return (String)this.get(key);
            }

            @Override
            public String merge(String key, String value, BiFunction<? super String, ? super String, ? extends String> remappingFunction) {
                return (String)this.get(key);
            }

            @Override
            public void clear() {
            }

            @Override
            public boolean remove(Object key, Object value) {
                return false;
            }

            @Override
            public String remove(Object key) {
                return (String)this.get(key);
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return Set.copyOf(super.entrySet());
            }

            @Override
            public Set<String> keySet() {
                return Set.copyOf(super.keySet());
            }

            @Override
            public Collection<String> values() {
                return List.copyOf(super.values());
            }

            @Override
            public boolean replace(String key, String oldValue, String newValue) {
                return false;
            }

            @Override
            public String replace(String key, String value) {
                return value;
            }

            @Override
            public void replaceAll(BiFunction<? super String, ? super String, ? extends String> function) {
            }
        };
    }

    public static enum PredefinedLink {
        DEV_DISCORD_CARD_IMAGE("discord/dev/card"),
        DEV_DISCORD_INVITE("discord/dev/invite");

        private final String key;

        private PredefinedLink(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

