/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.world.level.LevelReader;
import net.neoforged.fml.LogicalSide;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;

public final class SidedLocal<T> {
    private T client;
    private T server;

    public SidedLocal() {
    }

    public SidedLocal(Function<LogicalSide, T> defaultValue) {
        this.client = defaultValue.apply(LogicalSide.CLIENT);
        this.server = defaultValue.apply(LogicalSide.SERVER);
    }

    public static <T> SidedLocal<T> createEmpty() {
        return new SidedLocal<T>();
    }

    public static <T> SidedLocal<T> initializeSideBased(Function<LogicalSide, ? extends T> trade) {
        SidedLocal<T> s = SidedLocal.createEmpty();
        s.server = trade.apply(LogicalSide.SERVER);
        s.client = trade.apply(LogicalSide.CLIENT);
        return s;
    }

    public static <T> SidedLocal<T> initializeSeparately(Supplier<? extends T> server, Supplier<? extends T> client) {
        SidedLocal<T> s = SidedLocal.createEmpty();
        s.server = server.get();
        s.client = client.get();
        return s;
    }

    public static <T> SidedLocal<T> initializeForBoth(Supplier<? extends T> both) {
        SidedLocal<T> s = SidedLocal.createEmpty();
        s.server = both.get();
        s.client = both.get();
        return s;
    }

    public static <T> SidedLocal<T> initializeForBothF(Function<LogicalSide, ? extends T> both) {
        SidedLocal<T> s = SidedLocal.createEmpty();
        s.server = both.apply(LogicalSide.SERVER);
        s.client = both.apply(LogicalSide.CLIENT);
        return s;
    }

    public static <T> SidedLocal<T> withInitial(T server, T client) {
        SidedLocal<T> s = SidedLocal.createEmpty();
        s.server = server;
        s.client = client;
        return s;
    }

    public T get() {
        return this.get(LogicalSidePredictor.getCurrentLogicalSide());
    }

    public void set(T data) {
        this.set(LogicalSidePredictor.getCurrentLogicalSide(), data);
    }

    public T getAndSet(T data) {
        return this.getAndSet(LogicalSidePredictor.getCurrentLogicalSide(), data);
    }

    public void apply(UnaryOperator<T> op) {
        this.apply(LogicalSidePredictor.getCurrentLogicalSide(), op);
    }

    public boolean equalsTo(T value) {
        return Objects.equals(this.get(), value);
    }

    public T get(LevelReader level) {
        return this.get(LogicalSidePredictor.getCurrentLogicalSide(level));
    }

    public void set(LevelReader level, T data) {
        this.set(LogicalSidePredictor.getCurrentLogicalSide(level), data);
    }

    public T getAndSet(LevelReader level, T data) {
        return this.getAndSet(LogicalSidePredictor.getCurrentLogicalSide(level), data);
    }

    public void apply(LevelReader level, UnaryOperator<T> op) {
        this.apply(LogicalSidePredictor.getCurrentLogicalSide(level), op);
    }

    public boolean equalsTo(LevelReader level, T value) {
        return Objects.equals(this.get(level), value);
    }

    public T get(LogicalSide side) {
        if (side.isClient()) {
            return this.client;
        }
        return this.server;
    }

    public void set(LogicalSide side, T data) {
        if (side.isClient()) {
            this.client = data;
        } else {
            this.server = data;
        }
    }

    public T getAndSet(LogicalSide side, T data) {
        T prev = this.get(side);
        this.set(side, data);
        return prev;
    }

    public void apply(LogicalSide side, UnaryOperator<T> op) {
        this.set(side, op.apply(this.get(side)));
    }

    public boolean equalsTo(LogicalSide side, T value) {
        return Objects.equals(this.get(side), value);
    }

    public void applyForAllSides(UnaryOperator<T> op) {
        this.set(LogicalSide.SERVER, op.apply(this.get(LogicalSide.SERVER)));
        this.set(LogicalSide.CLIENT, op.apply(this.get(LogicalSide.CLIENT)));
    }

    public Stream<T> bothSides() {
        return Stream.of(this.client, this.server);
    }

    public void acceptBoth(Consumer<T> handler) {
        handler.accept(this.client);
        handler.accept(this.server);
    }

    public void acceptBoth(BiConsumer<T, T> handler) {
        handler.accept(this.client, this.server);
    }

    public String toString() {
        return "SidedLocal{client=" + String.valueOf(this.client) + ", server=" + String.valueOf(this.server) + "}";
    }
}

