/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own.inf;

import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.zeith.hammerlib.tiles.tooltip.own.IRenderableInfo;

public class TooltipInfoText
implements IRenderableInfo {
    protected MutableComponent text;
    public Font fontRenderer;
    public boolean dropShadow = true;

    public TooltipInfoText(Component text) {
        MutableComponent mc;
        this.text = text instanceof MutableComponent ? (mc = (MutableComponent)text) : text.copy();
        this.fontRenderer = Minecraft.getInstance().font;
    }

    public void setDropShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
    }

    public void setText(MutableComponent text) {
        this.text = text;
    }

    @Override
    public float getWidth() {
        return this.fontRenderer.width((FormattedText)this.getText());
    }

    @Override
    public float getHeight() {
        Objects.requireNonNull(this.fontRenderer);
        return 9.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gfx, float x, float y, DeltaTracker partialTime) {
        gfx.drawString(this.fontRenderer, this.getText().getVisualOrderText(), x, y, -1, this.dropShadow);
    }

    public MutableComponent getText() {
        return this.text;
    }
}

