/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own.impl;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.zeith.hammerlib.tiles.tooltip.ITooltipTile;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltip;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltipProvider;
import org.zeith.hammerlib.tiles.tooltip.own.impl.HLTooltipConsumer;

public class WrappedTooltipEngine
implements ITooltipProvider {
    public long lastUpdateTime;
    private final BlockEntity tile;
    private final ITooltipTile ttt;
    protected long updateRate = 5L;

    public WrappedTooltipEngine(BlockEntity tile, ITooltipTile ttt) {
        this.tile = tile;
        this.ttt = ttt;
    }

    @Override
    public void addInformation(ITooltip tip) {
        Player player = tip.getPlayer();
        this.ttt.addTooltip(new HLTooltipConsumer(tip), player);
    }

    @Override
    public boolean isTooltipDirty() {
        return this.tile.hasLevel() && this.tile.getLevel().getGameTime() - this.lastUpdateTime > this.updateRate;
    }

    @Override
    public void setTooltipDirty(boolean dirty) {
        if (!dirty && this.tile.hasLevel()) {
            this.lastUpdateTime = this.tile.getLevel().getGameTime();
        }
    }
}

