/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own.impl;

import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.zeith.hammerlib.tiles.tooltip.own.IRenderableInfo;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltip;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltipProvider;

@OnlyIn(value=Dist.CLIENT)
public class GuiTooltip
implements ITooltip {
    public final LinkedList<TooltipLine> infos = new LinkedList();
    protected Level world;
    protected BlockPos pos;
    protected BlockHitResult blockHitResult;
    protected Player player;
    protected Entity ent;
    protected float width;
    protected float height;
    public ITooltipProvider provider;

    protected void refresh() {
        this.width = 0.0f;
        this.height = 0.0f;
        for (int i = 0; i < this.infos.size(); ++i) {
            TooltipLine ln = this.infos.get(i);
            ln.refresh();
            this.width = Math.max(this.width, ln.width);
            this.height += ln.height;
        }
    }

    @Override
    public ITooltip add(IRenderableInfo info) {
        if (this.infos.isEmpty()) {
            this.newLine();
        }
        this.infos.getLast().addLast(info);
        this.refresh();
        return this;
    }

    @Override
    public ITooltip newLine() {
        this.infos.addLast(new TooltipLine());
        return this;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics pose, float x, float y, DeltaTracker partialTime) {
        for (TooltipLine ln : this.infos) {
            ln.render(pose, x, y, partialTime);
            y += ln.height;
        }
    }

    @Override
    public void reset() {
        this.infos.clear();
        this.refresh();
    }

    public boolean isDirty() {
        return this.provider != null && this.provider.isTooltipDirty();
    }

    @Override
    @Nullable
    public Level getWorld() {
        return this.world;
    }

    @Override
    @Nullable
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public Entity getEntity() {
        return this.ent;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public Direction getSideHit() {
        return this.blockHitResult != null ? this.blockHitResult.getDirection() : null;
    }

    @Override
    public Vec3 getHitVec() {
        return this.blockHitResult != null ? this.blockHitResult.getLocation() : null;
    }

    public GuiTooltip withLocation(Level world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        return this;
    }

    public GuiTooltip withEntity(Entity ent) {
        this.ent = ent;
        this.world = ent.level();
        return this;
    }

    public GuiTooltip withPlayer(Player player) {
        this.player = player;
        return this;
    }

    public GuiTooltip withBlockHitResult(BlockHitResult blockHitResult) {
        this.blockHitResult = blockHitResult;
        return this;
    }

    public GuiTooltip withProvider(ITooltipProvider provider) {
        this.provider = provider;
        provider.addInformation(this);
        return this;
    }

    public static class TooltipLine
    extends LinkedList<IRenderableInfo> {
        protected float width;
        protected float height;

        @OnlyIn(value=Dist.CLIENT)
        public void render(GuiGraphics pose, float x, float y, DeltaTracker partialTime) {
            for (IRenderableInfo info : this) {
                info.render(pose, x, y + (this.height - info.getHeight()) / 2.0f, partialTime);
                x += info.getWidth();
            }
        }

        protected void refresh() {
            this.width = 0.0f;
            this.height = 0.0f;
            for (IRenderableInfo info : this) {
                this.width += info.getWidth();
                this.height = Math.max(this.height, info.getHeight());
            }
        }
    }
}

