/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.recipes.RecipeBuilderExtension;
import org.zeith.hammerlib.core.adapter.recipe.BlastingRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.CampfireRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.ShapedRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.ShapelessRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.SmeltingRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.SmokingRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.StoneCutterRecipeBuilder;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.RecipeRegistrationContext;
import org.zeith.hammerlib.util.mcf.Resources;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;

public class RegisterRecipesEvent
extends Event
implements IRecipeRegistrationEvent<Recipe<?>>,
IModBusEvent {
    protected final HolderLookup.Provider registries;
    protected final ICondition.IContext context;
    private final List<RecipeHolder<?>> recipes = Lists.newArrayList();
    private final Set<ResourceLocation> removeRecipes = Sets.newHashSet();
    private final Predicate<ResourceLocation> idInUse;
    private final Map<String, RecipeRegistrationContext> contextMap = Maps.newHashMap();
    private final Map<Class<?>, RecipeBuilderExtension> extensions;

    public RegisterRecipesEvent(HolderLookup.Provider registries, ICondition.IContext context, Predicate<ResourceLocation> idInUse) {
        this.registries = registries;
        this.context = context;
        this.idInUse = idInUse;
        this.extensions = RecipeBuilderExtension.attach(this);
    }

    @Nullable
    public <T extends RecipeBuilderExtension> T extension(Class<T> type) {
        return (T)((RecipeBuilderExtension)Cast.cast(this.extensions.get(type), type));
    }

    public void add(RecipeHolder<?> recipe) {
        if (recipe == null || !this.enableRecipe(recipe)) {
            return;
        }
        this.recipes.add(recipe);
    }

    public boolean register(RecipeHolder<?> recipe) {
        if (recipe != null && this.enableRecipe(recipe.value().getType(), recipe.id())) {
            this.recipes.add(recipe);
            return true;
        }
        return false;
    }

    public Set<ResourceLocation> removedRecipes() {
        return Collections.unmodifiableSet(this.removeRecipes);
    }

    public RegisterRecipesEvent removeRecipe(ResourceLocation id) {
        this.removeRecipes.add(id);
        return this;
    }

    public StoneCutterRecipeBuilder stoneCutting() {
        return new StoneCutterRecipeBuilder(this);
    }

    public SmokingRecipeBuilder smoking() {
        return new SmokingRecipeBuilder(this);
    }

    public BlastingRecipeBuilder blasting() {
        return new BlastingRecipeBuilder(this);
    }

    public CampfireRecipeBuilder campfire() {
        return new CampfireRecipeBuilder(this);
    }

    public SmeltingRecipeBuilder smelting() {
        return new SmeltingRecipeBuilder(this);
    }

    public ShapedRecipeBuilder shaped() {
        return new ShapedRecipeBuilder(this);
    }

    public ShapelessRecipeBuilder shapeless() {
        return new ShapelessRecipeBuilder(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRecipeIdTaken(ResourceLocation id) {
        if (this.idInUse.test(id)) return true;
        if (!this.recipes.stream().map(RecipeHolder::id).anyMatch(arg_0 -> ((ResourceLocation)id).equals(arg_0))) return false;
        return true;
    }

    protected ResourceLocation transformRecipeIdToContext(ResourceLocation loc) {
        String contextModId = ModLoadingContext.get().getActiveNamespace();
        if (loc.getNamespace().equals(contextModId)) {
            return loc;
        }
        return Resources.location(contextModId, loc.getNamespace() + "/" + loc.getPath());
    }

    @Override
    public ResourceLocation nextId(Item item) {
        ResourceLocation tf;
        if (item == null || item == Items.AIR) {
            return null;
        }
        ResourceLocation rl = this.transformRecipeIdToContext(BuiltInRegistries.ITEM.getKey((Object)item));
        if (!this.isRecipeIdTaken(rl)) {
            return rl;
        }
        int lastIdx = 1;
        while (this.isRecipeIdTaken(tf = this.transformRecipeIdToContext(rl = Resources.location(rl.getNamespace(), rl.getPath() + "_" + lastIdx++)))) {
        }
        return tf;
    }

    @Override
    public void register(ResourceLocation id, Recipe<?> entry) {
        this.add(new RecipeHolder(id, entry));
    }

    public Stream<RecipeHolder<?>> getRecipes() {
        return this.recipes.stream();
    }

    @Override
    public boolean enableRecipe(RecipeType<?> type, ResourceLocation recipeId) {
        return this.getContext(recipeId.getNamespace()).enableRecipe(type, recipeId);
    }

    public boolean enableRecipe(RecipeHolder<?> recipe) {
        return this.enableRecipe(recipe.value().getType(), recipe.id());
    }

    public RecipeRegistrationContext getContext(String modid) {
        return this.contextMap.computeIfAbsent(modid, RecipeRegistrationContext::load);
    }

    @ApiStatus.Internal
    public void cleanup() {
        for (RecipeRegistrationContext value : this.contextMap.values()) {
            value.save();
        }
        this.contextMap.clear();
    }

    @Generated
    public HolderLookup.Provider getRegistries() {
        return this.registries;
    }

    @Generated
    public ICondition.IContext getContext() {
        return this.context;
    }
}

