/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.data;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import org.zeith.hammerlib.util.java.Cast;

public class DataPackRegistryLoadEvent
extends Event {
    private final Source source;
    private final GenericRegistry registry;

    public DataPackRegistryLoadEvent(Source source, WritableRegistry<?> registry) {
        this.source = source;
        this.registry = new GenericRegistry(registry);
    }

    public <T> Optional<WritableRegistry<T>> getRegistry(ResourceKey<? extends Registry<T>> key) {
        return this.registry.get(key);
    }

    public <T> boolean register(ResourceKey<? extends Registry<T>> key, ResourceLocation id, Supplier<T> value) {
        return this.getRegistry(key).map(wr -> {
            wr.register(ResourceKey.create((ResourceKey)wr.key(), (ResourceLocation)id), value.get(), RegistrationInfo.BUILT_IN);
            return true;
        }).orElse(false);
    }

    public <T> boolean inspect(ResourceKey<? extends Registry<T>> key, ResourceLocation id, Consumer<T> inspector) {
        return this.getRegistry(key).map(wr -> {
            Object t = wr.get(id);
            if (t != null) {
                inspector.accept(t);
            }
            return t != null;
        }).orElse(false);
    }

    public String toString() {
        return "DataPackRegistryLoadEvent{source=" + String.valueOf((Object)this.source) + ", registry=" + String.valueOf(this.registry.registry().key()) + "}";
    }

    @Generated
    public Source getSource() {
        return this.source;
    }

    public static enum Source {
        RELOADABLE_SERVER_REGISTRIES,
        REGISTRY_DATA_LOADER;

    }

    public record GenericRegistry(WritableRegistry<?> registry) {
        public <T> Optional<WritableRegistry<T>> get(ResourceKey<? extends Registry<T>> key) {
            return this.registry.key().equals(key) ? Optional.of((WritableRegistry)Cast.cast(this.registry)) : Optional.empty();
        }
    }
}

