/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.test.machine;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.zeith.api.wrench.IWrenchable;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.annotations.client.TileRenderer;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.api.recipes.IngredientWithCount;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.core.test.machine.BlockTestMachine;
import org.zeith.hammerlib.core.test.machine.ContainerTestMachine;
import org.zeith.hammerlib.core.test.machine.RecipeTestMachine;
import org.zeith.hammerlib.core.test.machine.TESRTestMachine;
import org.zeith.hammerlib.net.properties.PropertyInt;
import org.zeith.hammerlib.net.properties.PropertyResourceLocation;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.hammerlib.tiles.tooltip.EnumNumberFormat;
import org.zeith.hammerlib.tiles.tooltip.ProgressBar;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltip;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltipProvider;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.DirectStorage;

@SimplyRegister
public class TileTestMachine
extends TileSyncableTickable
implements IContainerTile,
IWrenchable,
ITooltipProvider {
    @RegistryName(value="test_machine")
    @TileRenderer(value=TESRTestMachine.class)
    public static final BlockEntityType<TileTestMachine> TEST_MACHINE = BlockAPI.createBlockEntityType(TileTestMachine::new, new Block[]{BlockTestMachine.TEST_MACHINE});
    @NBTSerializable
    private int _progress;
    @NBTSerializable
    private int _maxProgress = 200;
    @NBTSerializable
    public final SimpleInventory inventory = new SimpleInventory(3);
    @NBTSerializable
    private ResourceLocation _activeRecipeId;
    public final PropertyInt progress = new PropertyInt(DirectStorage.create(i -> {
        this._progress = i;
    }, () -> this._progress));
    public final PropertyInt maxProgress = new PropertyInt(DirectStorage.create(i -> {
        this._maxProgress = i;
    }, () -> this._maxProgress));
    public final PropertyResourceLocation activeRecipeId = new PropertyResourceLocation(DirectStorage.create(r -> {
        this._activeRecipeId = r;
    }, () -> this._activeRecipeId));
    public boolean dirty;

    public TileTestMachine(BlockPos pos, BlockState state) {
        super(TEST_MACHINE, pos, state);
        this.inventory.isStackValid = (i, s) -> i != 2;
        this.dispatcher.registerProperty("progress", this.progress);
        this.dispatcher.registerProperty("max_progress", this.maxProgress);
        this.dispatcher.registerProperty("ar_id", this.activeRecipeId);
    }

    @Override
    public void serverTick() {
        RecipeHolder recipe;
        RecipeTestMachine r = this.getActiveRecipe();
        if (this.isValidRecipe(r)) {
            int p = this._progress + 1;
            if (p >= r.getTime()) {
                ItemStack result = r.getRecipeOutput(this);
                if (this.output(result)) {
                    this.inventory.getItem(0).shrink(r.inputA.count());
                    this.inventory.getItem(1).shrink(r.inputB.count());
                    if (!this.isValidRecipe(r)) {
                        this.activeRecipeId.set(null);
                        r = null;
                        this.setEnabledState(false);
                    }
                    this.progress.setInt(0);
                }
            } else {
                this.progress.setInt(p);
            }
        } else {
            if (this._progress > 0) {
                this.progress.setInt(this._progress - 1);
                if (this._progress <= 0) {
                    this.setEnabledState(false);
                }
            }
            this.activeRecipeId.set(null);
            r = null;
        }
        if (r == null && this.atTickRate(10) && (recipe = (RecipeHolder)RecipeHelper.getRecipeHolders(this.level, RecipeTestMachine.TYPE).filter(this::isValidRecipe).findFirst().orElse(null)) != null) {
            RecipeTestMachine rec = (RecipeTestMachine)recipe.value();
            if (rec.time != this._maxProgress) {
                this.progress.setInt(0);
            }
            this.maxProgress.setInt(rec.time);
            this.activeRecipeId.set(recipe.id());
            this.setEnabledState(true);
        }
    }

    @Override
    public void clientTick() {
        this.setTooltipDirty(true);
    }

    public void setEnabledState(boolean enabled) {
        BlockState s = this.level.getBlockState(this.worldPosition);
        if (s.getBlock() == BlockTestMachine.TEST_MACHINE) {
            s = (BlockState)s.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(enabled));
            this.level.setBlockAndUpdate(this.worldPosition, s);
            this.setBlockState(s);
        }
    }

    public RecipeTestMachine getActiveRecipe() {
        return this.level.getRecipeManager().byKey(this._activeRecipeId).map(RecipeHolder::value).map(Cast.convertTo(RecipeTestMachine.class)).orElse(null);
    }

    private boolean output(ItemStack stack) {
        if (this.canStore(stack)) {
            ItemStack s = this.inventory.getItem(2);
            if (s.isEmpty()) {
                this.inventory.setItem(2, stack);
            } else {
                this.inventory.getItem(2).grow(stack.getCount());
            }
            return true;
        }
        return false;
    }

    private boolean isValidRecipe(RecipeHolder<RecipeTestMachine> recipe) {
        return recipe != null && this.isValidRecipe((RecipeTestMachine)recipe.value());
    }

    private boolean isValidRecipe(RecipeTestMachine recipe) {
        return recipe != null && recipe.inputA.test(this.inventory.getItem(0)) && recipe.inputB.test(this.inventory.getItem(1)) && this.canStore(recipe.getRecipeOutput(this));
    }

    private boolean canStore(ItemStack result) {
        ItemStack stack = this.inventory.getItem(2);
        if (stack.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)stack)) {
            return false;
        }
        return stack.getCount() + result.getCount() <= Math.min(this.inventory.getMaxStackSize(), result.getMaxStackSize());
    }

    @Override
    public AbstractContainerMenu openContainer(Player player, int windowId) {
        return new ContainerTestMachine(player, windowId, this);
    }

    @Override
    public boolean onWrenchUsed(UseOnContext context) {
        Direction facing;
        Direction origin;
        BlockState state;
        if (context.getLevel().isClientSide()) {
            return true;
        }
        Direction d = context.getClickedFace();
        if (context.getPlayer().isShiftKeyDown()) {
            d = d.getOpposite();
        }
        if ((state = this.level.getBlockState(this.worldPosition)).getBlock() == BlockTestMachine.TEST_MACHINE && (origin = (facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))) != (facing = d == Direction.UP ? facing.getClockWise() : (d == Direction.DOWN ? facing.getCounterClockWise() : d))) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing));
        }
        return true;
    }

    @Override
    public boolean isTooltipDirty() {
        return this.dirty;
    }

    @Override
    public void setTooltipDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void addInformation(ITooltip tip) {
        RecipeTestMachine recipe = this.getActiveRecipe();
        if (recipe != null) {
            IngredientWithCount ingA = recipe.inputA;
            IngredientWithCount ingB = recipe.inputB;
            ItemStack stored0 = this.inventory.getItem(0);
            ItemStack stored1 = this.inventory.getItem(1);
            ItemStack inA = ingA.test(stored0) ? stored0.copy() : RecipeHelper.cycleIngredientStack(ingA.input(), 1000L);
            ItemStack inB = ingB.test(stored1) ? stored1.copy() : RecipeHelper.cycleIngredientStack(ingB.input(), 1000L);
            if (!inA.isEmpty()) {
                inA.setCount(recipe.inputA.count());
            }
            if (!inB.isEmpty()) {
                inB.setCount(recipe.inputB.count());
            }
            tip.addStack(inA, 9.0f, 9.0f).addText((Component)Component.literal((String)" + ")).addStack(inB, 9.0f, 9.0f).addText((Component)Component.literal((String)" = ")).addStack(recipe.getRecipeOutput(this), 9.0f, 9.0f).newLine();
            tip.addSpacing(0.0f, 4.0f).newLine();
            ProgressBar bar = new ProgressBar(this._maxProgress).setProgress(this._progress).withStyle(ProgressBar.ProgressBarStyle.FORGE_ENERGY_STYLE).withNumberFormat(EnumNumberFormat.FULL);
            float hue = bar.getProgress() / 3.5f;
            bar.filledMainColor = 0xFF000000 | Mth.hsvToRgb((float)hue, (float)1.0f, (float)1.0f);
            bar.filledAlternateColor = 0xFF000000 | Mth.hsvToRgb((float)hue, (float)1.0f, (float)0.75f);
            tip.addText((Component)Component.literal((String)"Progress: ")).addProgressBar(bar);
        }
    }
}

