/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.test.machine;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiRootObject;
import org.zeith.hammerlib.client.flowgui.test.TestFlowgui;
import org.zeith.hammerlib.client.screen.IAdvancedGui;
import org.zeith.hammerlib.client.screen.ScreenWTFMojang;
import org.zeith.hammerlib.client.utils.FXUtils;
import org.zeith.hammerlib.client.utils.RenderUtils;
import org.zeith.hammerlib.core.test.machine.ContainerTestMachine;
import org.zeith.hammerlib.core.test.machine.TileTestMachine;

@IAdvancedGui.ApplyToJEI
public class ScreenTestMachine
extends ScreenWTFMojang<ContainerTestMachine>
implements IAdvancedGui<ScreenTestMachine> {
    public TileTestMachine tile;

    public ScreenTestMachine(ContainerTestMachine container, Inventory inv, Component label) {
        super(container, inv, label);
        this.tile = container.tile;
        this.setSize(176, 166);
    }

    protected void init() {
        GuiRootObject r = (GuiRootObject)this.addRenderableWidget(TestFlowgui.assemble(this.width, this.height));
        GuiObject inp = r.findByPath("core/input");
        if (inp != null) {
            Slot link = (Slot)((ContainerTestMachine)this.menu).slots.get(((ContainerTestMachine)this.menu).slots.size() - 3);
            inp.addChild(GuiObject.create("islot").slot(link).size(32.0f, 16.0f).pivotAtCenter());
        }
        super.init();
    }

    protected void containerTick() {
        ((ContainerTestMachine)this.menu).containerTick();
        super.containerTick();
    }

    @Override
    protected void renderBackground(GuiGraphics pose, float partialTime, int mouseX, int mouseY) {
        FXUtils.bindTexture("hammerlib", "textures/gui/test_machine.png");
        RenderUtils.drawTexturedModalRect(pose, (float)this.leftPos, (float)this.topPos, 0.0f, 0.0f, (float)this.imageWidth, (float)this.imageHeight);
        float maxProgress = 200.0f;
        int mp = this.tile.maxProgress.getInt();
        if (mp > 0) {
            maxProgress = mp;
        }
        RenderUtils.drawTexturedModalRect(pose, (float)(this.leftPos + 80), (float)(this.topPos + 35), (float)this.imageWidth, 14.0f, (float)(22 * this.tile.progress.getInt()) / maxProgress, 16.0f);
    }
}

