/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.test.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.abstractions.recipes.IRecipeVisualizer;
import org.zeith.hammerlib.abstractions.recipes.IVisualizedRecipe;
import org.zeith.hammerlib.abstractions.recipes.layout.ISlotBuilder;
import org.zeith.hammerlib.abstractions.recipes.layout.IVisualizerBuilder;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.recipes.BaseCustomRecipe;
import org.zeith.hammerlib.api.recipes.BaseRecipe;
import org.zeith.hammerlib.api.recipes.IngredientWithCount;
import org.zeith.hammerlib.api.registrars.SerializableRecipeType;
import org.zeith.hammerlib.client.render.IGuiDrawable;
import org.zeith.hammerlib.core.adapter.recipe.RecipeBuilder;
import org.zeith.hammerlib.core.test.machine.BlockTestMachine;
import org.zeith.hammerlib.core.test.machine.TileTestMachine;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;

@SimplyRegister
public class RecipeTestMachine
extends BaseCustomRecipe<RecipeTestMachine> {
    @RegistryName(value="test_machine")
    public static final TestMachineRecipeType TYPE = new TestMachineRecipeType();
    public final IngredientWithCount inputA;
    public final IngredientWithCount inputB;
    public final ItemStack output;
    public final int time;

    public RecipeTestMachine(String group, int time, ItemStack output, IngredientWithCount inputA, IngredientWithCount inputB) {
        super(group);
        this.vanillaResult = output;
        if (!inputA.isEmpty()) {
            this.vanillaIngredients.addAll(inputA.applyCount());
        }
        if (!inputB.isEmpty()) {
            this.vanillaIngredients.addAll(inputB.applyCount());
        }
        this.time = time;
        this.inputA = inputA;
        this.inputB = inputB;
        this.output = output;
    }

    @Override
    protected SerializableRecipeType<RecipeTestMachine> getRecipeType() {
        return TYPE;
    }

    public ItemStack getRecipeOutput(TileTestMachine machine) {
        return this.output.copy();
    }

    @Generated
    public int getTime() {
        return this.time;
    }

    public static class TestMachineRecipeType
    extends SerializableRecipeType<RecipeTestMachine> {
        private static final MapCodec<RecipeTestMachine> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ExtraCodecs.ESCAPED_STRING.optionalFieldOf("group", (Object)"").forGetter(BaseRecipe::getGroup), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("time", (Object)200).forGetter(RecipeTestMachine::getTime), (App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(o -> o.output), (App)IngredientWithCount.CODEC.fieldOf("a").forGetter(o -> o.inputA), (App)IngredientWithCount.CODEC.fieldOf("b").forGetter(o -> o.inputB)).apply((Applicative)inst, RecipeTestMachine::new));

        public MapCodec<RecipeTestMachine> codec() {
            return CODEC;
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, RecipeTestMachine recipe) {
            recipe.inputA.toNetwork(buf);
            recipe.inputB.toNetwork(buf);
            buf.writeVarInt(recipe.time);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)recipe.output);
            buf.writeUtf(recipe.group);
        }

        @Override
        @Nullable
        public RecipeTestMachine fromNetwork(RegistryFriendlyByteBuf buf) {
            IngredientWithCount ingrA = IngredientWithCount.fromNetwork(buf);
            IngredientWithCount ingrB = IngredientWithCount.fromNetwork(buf);
            int time = buf.readVarInt();
            ItemStack res = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            String group = buf.readUtf();
            return new RecipeTestMachine(group, time, res, ingrA, ingrB);
        }

        @Override
        public void initVisuals(Consumer<IRecipeVisualizer<RecipeTestMachine, ?>> viualizerConsumer) {
            viualizerConsumer.accept(IRecipeVisualizer.simple(VisualizedTestMachine.class, IRecipeVisualizer.groupBuilder().title((Component)BlockTestMachine.TEST_MACHINE.getName()).size(52, 36).icon(IGuiDrawable.ofItem(new ItemStack((ItemLike)BlockTestMachine.TEST_MACHINE))).catalyst(new ItemStack((ItemLike)BlockTestMachine.TEST_MACHINE)).build(), VisualizedTestMachine::new));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class VisualizedTestMachine
    implements IVisualizedRecipe<RecipeTestMachine> {
        final RecipeHolder<RecipeTestMachine> recipe;

        public VisualizedTestMachine(RecipeHolder<RecipeTestMachine> recipe) {
            this.recipe = recipe;
        }

        @Override
        public RecipeHolder<RecipeTestMachine> getRecipe() {
            return this.recipe;
        }

        @Override
        public void setupLayout(IVisualizerBuilder builder) {
            RecipeTestMachine recipe = (RecipeTestMachine)this.recipe.value();
            ((ISlotBuilder)builder.addSlot(ISlotBuilder.SlotRole.INPUT, 0, 0).addItemStacks(Stream.of(recipe.inputA.input().getItems()).peek(s -> s.setCount(recipe.inputA.count())).toList())).build();
            ((ISlotBuilder)builder.addSlot(ISlotBuilder.SlotRole.INPUT, 0, 18).addItemStacks(Stream.of(recipe.inputB.input().getItems()).peek(s -> s.setCount(recipe.inputB.count())).toList())).build();
            ((ISlotBuilder)builder.addSlot(ISlotBuilder.SlotRole.OUTPUT, 36, 9).addItemStack(recipe.output)).build();
        }
    }

    public static class TestMachineRecipeBuilder
    extends RecipeBuilder<TestMachineRecipeBuilder, Recipe<?>> {
        protected IngredientWithCount inputA;
        protected IngredientWithCount inputB;
        protected int time = 100;

        public TestMachineRecipeBuilder(IRecipeRegistrationEvent<Recipe<?>> event) {
            super(event);
        }

        public TestMachineRecipeBuilder time(int time) {
            this.time = time;
            return this;
        }

        @Override
        public TestMachineRecipeBuilder result(ItemStack stack) {
            this.result = stack;
            return this;
        }

        @Override
        public TestMachineRecipeBuilder result(ItemLike provider) {
            this.result = new ItemStack(provider);
            return this;
        }

        @Override
        public TestMachineRecipeBuilder result(ItemLike provider, int count) {
            this.result = new ItemStack(provider, count);
            return this;
        }

        public TestMachineRecipeBuilder top(Object in, int count) {
            this.inputA = this.parseIngredient(in, count);
            return this;
        }

        public TestMachineRecipeBuilder bottom(Object in, int count) {
            this.inputB = this.parseIngredient(in, count);
            return this;
        }

        @Override
        protected void validate() throws IllegalStateException {
            if (this.inputA == null) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " does not have a defined input A!");
            }
            if (this.inputB == null) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " does not have a defined input B!");
            }
            if (this.result.isEmpty()) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " does not have a defined output!");
            }
        }

        @Override
        public void register() throws IllegalStateException {
            this.validate();
            ResourceLocation id = this.getIdentifier();
            this.event.register(id, new RecipeTestMachine(this.group, this.time, this.result, this.inputA, this.inputB));
        }
    }
}

