/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.zeith.api.wrench.IWrenchItem;
import org.zeith.hammerlib.api.items.CreativeTab;
import org.zeith.hammerlib.api.items.IDynamicallyTaggedItem;
import org.zeith.hammerlib.api.items.ITabItem;
import org.zeith.hammerlib.core.adapter.TagAdapter;
import org.zeith.hammerlib.core.init.TagsHL;
import org.zeith.hammerlib.proxy.HLConstants;

public class ItemWrench
extends Item
implements IWrenchItem,
IDynamicallyTaggedItem,
ITabItem {
    protected boolean defaultRecipe = true;
    public final List<CreativeTab> extraTabs = new ArrayList<CreativeTab>(List.of(HLConstants.HL_TAB));

    public ItemWrench(Item.Properties props) {
        super(props);
        TagAdapter.bind(TagsHL.Items.TOOLS_WRENCH, this);
    }

    public void disableDefaultRecipe() {
        this.defaultRecipe = false;
    }

    public boolean defaultRecipe() {
        return this.defaultRecipe;
    }

    @Override
    public Set<CreativeModeTab> getCreativeTabs() {
        return this.extraTabs.stream().map(CreativeTab::tab).collect(Collectors.toSet());
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return HLConstants.HL_TAB.tab();
    }

    @Override
    public void playWrenchSound(UseOnContext context) {
        Level world = context.getLevel();
        if (!world.isClientSide && world instanceof ServerLevel) {
            Vec3 e = context.getClickLocation();
            world.playSound(null, e.x, e.y, e.z, SoundEvents.TRIPWIRE_CLICK_ON, SoundSource.PLAYERS, 1.0f, 1.5f);
        }
    }

    @Override
    public Stream<TagKey<Item>> getExtraItemTags(ItemStack stack) {
        return Stream.of(TagsHL.Items.TOOLS_WRENCH);
    }
}

