/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.event.recipe.BuildTagsEvent;
import org.zeith.hammerlib.util.java.Cast;

public class TagAdapter {
    static final Map<TagKey<Block>, Set<Block>> blockTags = new ConcurrentHashMap<TagKey<Block>, Set<Block>>();
    static final Map<TagKey<Item>, Set<Item>> itemTags = new ConcurrentHashMap<TagKey<Item>, Set<Item>>();
    static final Map<TagKey<Fluid>, Set<Fluid>> fluidTags = new ConcurrentHashMap<TagKey<Fluid>, Set<Fluid>>();
    static final Map<ResourceKey<? extends Registry<?>>, Map<TagKey<?>, Set<?>>> staticTags = new ConcurrentHashMap();

    private static <T> Map<TagKey<T>, Set<T>> getTagsFor(ResourceKey<? extends Registry<T>> registry) {
        return (Map)Cast.cast(staticTags.computeIfAbsent(registry, r -> new ConcurrentHashMap()));
    }

    public static synchronized <T> void bind(TagKey<T> tag, T ... values) {
        Map<TagKey<T>, Set<T>> tags = TagAdapter.getTagsFor(tag.registry());
        tags.computeIfAbsent(tag, b -> new HashSet()).addAll(List.of(values));
    }

    public static void applyTags(BuildTagsEvent evt) {
        Map tags = TagAdapter.getTagsFor(evt.reg.key());
        tags.forEach((tag, values) -> evt.addAllToTag(tag, values));
    }

    static {
        HammerLib.EVENT_BUS.addListener(TagAdapter::applyTags);
    }
}

